import db from "../db-config.js";
import {
  checkNameInOrganization,
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getQuestions,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import AuditTemplate from "../sequelize/AuditTemplateSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create and update Audit Template , handle multiple creations */
// export const createUpdatedAuditTemplate = async (req, res) => {
//   const { id, name, sections, description, organization } = req.body;
//   const body = await encodeAndStringifyFields(req.body);
//   req.body = body;

//   let organizationId = organization;
//   /**If id comes in body then it will update the query */
//   if (id) {
//     req.body.updated_by = req.user.sessionid;
//     if (organization && organization.length === 0) {
//       return sendResponse(res, 400, "Please Select at least one organization");
//     }
//     // console.log(req.body);
//     const result = await settingsUpdater(
//       AuditTemplate,
//       organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Audit Template",
//       `This user Update other Skills which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     /**Check that this organization have that particular name or not*/
//     const insertPromises = organizationId.map(async (element) => {
//       /**Check that this organization have that particular name or not*/
//       const checkNameWithOrganization = await checkNameInOrganization(
//         "audit_template",
//         name,
//         element
//       );
//       if (checkNameWithOrganization.length === 0) {
//         req.body.created_by = req.user.sessionid;
//         req.body.organization = element;

//         const unique_id = await uniqueIdGenerator(
//           req.body.organization,
//           req?.body?.department,
//           "AuditTemplate",
//           "audit_template",
//           "unique_id",
//           "unique_id"
//         );
//         req.body.unique_id = unique_id;

//         /** Insert Audit Template details */
//         const { query, values } = createQueryBuilder(AuditTemplate, {
//           ...req.body,
//           organization: element,
//         });
//         const [insertedAuditTemplate] = await db.query(query, values);
//         /** Insert record for activity log */
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Audit Template",
//           `This user created a new other Skills named ${name} for organization ${element}`
//         );
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all Audit Template */
// export const viewAllAuditTemplate = async (req, res) => {
//   const { id } = req.params;
//   const condition = await whereCondition({
//     table: "audit_template",
//     page: req.query.page,
//     all: req.query.all,
//     pageSize: req.query.pageSize,
//     filter: req.query.filter,
//     id,
//     grouped: req.query.grouped,
//     user: req.user,
//   });

//   const searchTableName = [
//     "audit_template.name",
//     "audit_template.description",
//     "organization.name",
//     "CONCAT(createdUser.name, ' ', createdUser.surname)",
//   ];

//   /** If value comes with any search condition then search that word */
//   let searchCondition = await searchConditionRecord(
//     req.query.search,
//     searchTableName
//   );

//   /**Make Joins according to tables */
//   const joins = [
//     {
//       type: "left",
//       targetTable: "users as createdUser",
//       onCondition: "createdUser.id = audit_template.created_by",
//     },
//     {
//       type: "left",
//       targetTable: "organization",
//       onCondition: "organization.id = audit_template.organization",
//     },
//   ];
//   const joinsRecord = await makeJoins(joins);

//   /**Record of all alert */
//   const auditTemplateDataFetchQuery = `SELECT audit_template.*, organization.name as organization_name ,createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id , createdUser.profile as created_by_profile
//     FROM audit_template
//     ${joinsRecord}
//     where audit_template.deleted = 0  ${searchCondition} ${condition}`;
//   let [auditTemplateDataFetch] = await db.query(auditTemplateDataFetchQuery);
//   auditTemplateDataFetch = await decodeAndParseFields(auditTemplateDataFetch);

//   for (let i = 0; i < auditTemplateDataFetch.length; i++) {
//     if (req.query.grouped == "true") {
//       const [organizations] = await db.query(
//         `SELECT organization FROM audit_template WHERE deleted = 0 AND name = ?`,
//         [auditTemplateDataFetch[i].name]
//       );
//       const arr = organizations.map((item) => item.organization);
//       auditTemplateDataFetch[i].organizations = arr;
//     }
//   }

//   /**Count all audit Template */
//   const totalRecord = await countQueryCondition(auditTemplateDataFetchQuery);
//   return sendResponse(res, 200, auditTemplateDataFetch, totalRecord);
// };

/**Function to delete a specific Audit Template */
export const deleteAuditTemplate = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("audit_template", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "Audit Template", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};

/////////////////////////////////////////////////////////////////////
// import db from "../db-config.js";
// import {
//   checkNameInOrganization,
//   countQueryCondition,
//   createQueryBuilder,
//   decodeSingle_statement,
//   deleteSettingRecord,
//   encodeSingle_statement,
//   getOrganizationAccordingToDepartment,
//   getQuestions,
//   insertActivityLog,
//   insertUpdateQuestions,
//   makeJoins,
//   searchConditionRecord,
//   settingsUpdater,
//   whereCondition,
// } from "../helper/general.js";
// import AuditTemplate from "../sequelize/AuditTemplateSchema.js";
// import { sendResponse } from "../helper/wrapper.js";

// /**Function to create and update Audit Template , handle multiple creations */

export const createUpdatedAuditTemplate = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "AuditTemplate",
      "audit_template",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(AuditTemplate, req.body)
    : createQueryBuilder(AuditTemplate, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "AuditTemplate", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

// /**Function to view all Audit Template */
export const viewAllAuditTemplate = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "audit_template");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "audit_template",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  const searchTableName = [
    "audit_template.name",
    "audit_template.description",
    "CONCAT(createdUser.name, ' ', createdUser.surname)",
  ];

  /** If value comes with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = audit_template.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = audit_template.organization",
    // },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all alert */
  const auditTemplateDataFetchQuery = `SELECT audit_template.*, audit_template.organization as organizations ,createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id , createdUser.profile as created_by_profile
    FROM audit_template
    ${joinsRecord}
    where audit_template.deleted = 0  ${searchCondition} ${organizationCondition} ${condition}`;
  let [auditTemplateDataFetch] = await db.query(auditTemplateDataFetchQuery);

  // auditTemplateDataFetch.forEach(async (item) => {
  //   item.description = await decodeSingle_statement(item.description);
  // });

  auditTemplateDataFetch = await getListingData(auditTemplateDataFetch);

  /**Count all audit Template */
  const totalRecord = await countQueryCondition(auditTemplateDataFetchQuery);

  return sendResponse(res, 200, auditTemplateDataFetch, totalRecord);
};

// /**Function to delete a specific Audit Template */
// export const deleteAuditTemplate = async (req, res) => {
//   const { id } = req.params;
//   const deleteRecordQuery = await deleteSettingRecord("audit_template", id);
//   if (deleteRecordQuery) {
//     /** also delete questions of that template */
//     await insertUpdateQuestions(id, req.user.sessionid, null, "delete");
//     /**Insert record for activity log */
//     insertActivityLog(req.user.sessionid, "delete", "Audit Template", id);
//     return sendResponse(res, 200, "Record deleted successfully");
//   }
// }
