import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement, 
    uniqueIdGenerator,
  } from "../helper/general.js";
  import ComplaintCategory from "../sequelize/ComplaintCategorySchema.js";

  /** Function to create or update ComplaintCategory */
  export const createUpdateComplaintCategory = async (req, res) => {
    const { id, name, description } = req.body;
    const encodedDescription = await encodeSingle_statement(description);

    if (id) {
      const result = await settingsUpdater(
        ComplaintCategory,
        req.body.organization,
        req.body,
        req.user
      );
      if (!result) {
        return sendResponse(res, 404, "No data found");
      }
      await insertActivityLog(req.user.sessionid, "update", "ComplaintCategory", `This user updated ComplaintCategory with id: ${id}`);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
      const insertPromises = req.body.organization.map(async (org) => {
        const [checkName] = await db.query(`SELECT name FROM complaint_category WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
        if (checkName.length === 0) {
          const unique_id = await uniqueIdGenerator(
            org,
            req?.body?.department,
            "CC",
            "complaint_category",
            "unique_id",
            "unique_id"
          );
          await db.query(`INSERT INTO complaint_category (name, description, created_by, organization,unique_id) VALUES (?, ?,?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
          await insertActivityLog(req.user.sessionid, "create", "ComplaintCategory", `This user created a new ComplaintCategory '${name}' for organization ${org}`);
        }
      });
      await Promise.all(insertPromises);
      return sendResponse(res, 200, "Record created successfully");
    }
  };

  /** Function to view all or single ComplaintCategory */
  export const viewComplaintCategory = async (req, res) => {
    const { id } = req.params;
    const condition = await whereCondition({
      table: "complaint_category",
      page: req.query.page,
      all: req.query.all,
      pageSize: req.query.pageSize,
      filter: req.query.filter,
      id,
      user: req.user,
      grouped: req.query.grouped,
    });

    const searchFields = [
      "complaint_category.name",
      "complaint_category.description",
      "users.name",
      "organization.name"
    ];
    let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    const joins = [
      { type: "left", targetTable: "users", onCondition: "users.id = complaint_category.created_by" },
      { type: "left", targetTable: "organization", onCondition: "organization.id = complaint_category.organization" }
    ];
    const joinsRecord = await makeJoins(joins);

    const fetchQuery = `SELECT complaint_category.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM complaint_category ${joinsRecord} WHERE complaint_category.deleted = 0 ${searchCondition} ${condition}`;
    let [records] = await db.query(fetchQuery);

    for (const record of records) {
      record.description = await decodeSingle_statement(record.description);
       if (req.query.grouped == "true") {
        const [organizations] = await db.query(
          `SELECT organization FROM complaint_category WHERE deleted = 0 AND name = ?`,
          [record.name]
        );
        const arr = organizations.map((item) => item.organization);
        record.organizations = arr;
      }
    }

    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete ComplaintCategory */
  export const deleteComplaintCategory = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("complaint_category", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "ComplaintCategory", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };