import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteSettingRecord,
  encodeAndStringifyFields,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import ContractorForm from "../sequelize/ContractorFormSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create new Insurance Policy Impact for employee  */
export const createUpdateContractorForm = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "CFM",
      "contractor_forms",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(ContractorForm, req.body)
    : createQueryBuilder(ContractorForm, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "ContractorForm", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const viewContractorForm = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "contractor_forms");

  const searchTableName = [
    "contractor_forms.name",
    "contractor_forms.description",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_forms.created_by",
    },

    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = contractor_forms.department",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const insurancePolicyImpactQuery = `SELECT contractor_forms.*,users.id AS created_by_id, users.name AS created_by, contractor_forms.organization AS organizations , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM contractor_forms ${joinsRecord} where contractor_forms.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // return console.log(
  //   insurancePolicyImpactQuery,
  //   "insurancePolicyImpactQuery"
  // );
  let [insurancePolicyImpactRecord] = await db.query(insurancePolicyImpactQuery);

  insurancePolicyImpactRecord = await getListingData(insurancePolicyImpactRecord);

  /**Count all organization */
  const totalRecord = await countQueryCondition(insurancePolicyImpactQuery);

  return sendResponse(res, 200, insurancePolicyImpactRecord, totalRecord);
};

/**Function to delete a specific Insurance Policy Impact */
export const deleteContractorForm = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("contractor_forms", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Insurance Policy Impact", id);
    return sendResponse(res, 200, "Record deleted Successfully");
  }
};
/**Function to view all and single Insurance Policy Impact */
