import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement, 
    uniqueIdGenerator,
  } from "../helper/general.js";
  import CrisisLocation from "../sequelize/CrisisLocationSchema.js";

  /** Function to create or update CrisisLocation */
  export const createUpdateCrisisLocation = async (req, res) => {
    const { id, name, description, department } = req.body;
    const encodedDescription = await encodeSingle_statement(description);

    if (id) {
      const result = await settingsUpdater(
        CrisisLocation,
        req.body.organization,
        req.body,
        req.user
      );
      if (!result) {
        return sendResponse(res, 404, "No data found");
      }
      await insertActivityLog(req.user.sessionid, "update", "CrisisLocation", `This user updated CrisisLocation with id: ${id}`);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
       // add unique_id if id is not present
  if (!id) {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      department,
      "CL",
      "crisis_location",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }
      const insertPromises = req.body.organization.map(async (org) => {
        const [checkName] = await db.query(`SELECT name FROM crisis_location WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
        if (checkName.length === 0) {
          await db.query(`INSERT INTO crisis_location (name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`, 
            [name, encodedDescription, req.user.sessionid, org, req.body.unique_id]
          );
          await insertActivityLog(req.user.sessionid, "create", "CrisisLocation", `This user created a new CrisisLocation '${name}' for organization ${org}`);
        }
      });
      await Promise.all(insertPromises);
      return sendResponse(res, 200, "Record created successfully");
    }
  };

  /** Function to view all or single CrisisLocation */
  export const viewCrisisLocation = async (req, res) => {
    const { id } = req.params;
    const condition = await whereCondition({
      table: "crisis_location",
      page: req.query.page,
      all: req.query.all,
      pageSize: req.query.pageSize,
      filter: req.query.filter,
      id,
      user: req.user,
      grouped: req.query.grouped,
    });

    const searchFields = [
      "crisis_location.name",
      "crisis_location.description",
      "users.name",
      "organization.name"
    ];
    let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    const joins = [
      { type: "left", targetTable: "users", onCondition: "users.id = crisis_location.created_by" },
      { type: "left", targetTable: "organization", onCondition: "organization.id = crisis_location.organization" }
    ];
    const joinsRecord = await makeJoins(joins);

    const fetchQuery = `SELECT crisis_location.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM crisis_location ${joinsRecord} WHERE crisis_location.deleted = 0 ${searchCondition} ${condition}`;
    let [records] = await db.query(fetchQuery);

    for (const record of records) {
      record.description = await decodeSingle_statement(record.description);
      if (req.query.grouped == "true") {
        const [organizations] = await db.query(
          `SELECT organization FROM crisis_location WHERE deleted = 0 AND name = ?`,
          [record.name]
        );
        const arr = organizations.map((item) => item.organization);
        record.organizations = arr;
      }
    }

    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete CrisisLocation */
  export const deleteCrisisLocation = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("crisis_location", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "CrisisLocation", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };