import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import InsurancePolicyImpact from "../sequelize/InsurancePolicyImpactSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/**Function to create new Insurance Policy Impact for employee  */
export const createUpdateInsurancePolicyImpact = async (req, res) => {
  const { id, name, description, organization } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "InsurancePolicyImpact",
      "insurance_policy_impact",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "insurance_policy_impact",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Insurance Policy name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Insurance Policy name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(
      InsurancePolicyImpact,
      req.body
    );
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "InsurancePolicyImpact",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(
      InsurancePolicyImpact,
      req.body
    );
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "InsurancePolicyImpact",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       200,
  //       "Please select at least one business structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     InsurancePolicyImpact,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "insurance Policy Impact",
  //     `This user Update insurance Policy Impact which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   /** Insert new record */
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM insurance_policy_impact WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     // If record not found for that name with particular organization, insert the record
  //     if (checkNameWithOrganization.length === 0) {
  //       const unique_id = await uniqueIdGenerator(
  //         element,
  //         req?.body?.department,
  //         "IPI",
  //         "insurance_policy_impact",
  //         "unique_id",
  //         "unique_id"
  //       );
  //       // Insert insurance Policy Impact details
  //       const insertInsurancePolicyImpactQuery = `INSERT INTO insurance_policy_impact(name, description, created_by, organization,unique_id) VALUES (?, ?,?, ?, ?)`;
  //       await db.query(insertInsurancePolicyImpactQuery, [
  //         name,
  //         encodedDescription,
  //         req.user.sessionid,
  //         element,
  //         unique_id
  //       ]);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "insurance Policy Impact",
  //         `This user created a new category '${name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all and single Insurance Policy Impact */
export const viewInsurancePolicyImpact = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "insurance_policy_impact"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "insurance_policy_impact.name",
    "insurance_policy_impact.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = insurance_policy_impact.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let insurancePolicyQuery = `SELECT 
  insurance_policy_impact.*, 
  insurance_policy_impact.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM insurance_policy_impact
${joinsRecord} 
WHERE insurance_policy_impact.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [insurancePolicyImpact] = await db.query(insurancePolicyQuery);
  insurancePolicyImpact = await getListingData(insurancePolicyImpact);
  /**Count all organization */
  const totalRecord = await countQueryCondition(insurancePolicyQuery);
  return sendResponse(res, 200, insurancePolicyImpact, totalRecord);

  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "insurance_policy_impact",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchTableName = [
  //   "insurance_policy_impact.name",
  //   "insurance_policy_impact.description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = insurance_policy_impact.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = insurance_policy_impact.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "department",
  //     onCondition: "department.id = insurance_policy_impact.department",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const insurancePolicyImpactQuery = `SELECT insurance_policy_impact.*,users.id AS created_by_id, users.name AS created_by, organization.name AS organization_name , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM insurance_policy_impact ${joinsRecord} where insurance_policy_impact.deleted = 0 ${searchCondition} ${condition}`;
  // // return console.log(
  // //   insurancePolicyImpactQuery,
  // //   "insurancePolicyImpactQuery"
  // // );
  // let [insurancePolicyImpactRecord] = await db.query(
  //   insurancePolicyImpactQuery
  // );

  // for (const item of insurancePolicyImpactRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM insurance_policy_impact WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  // /**Count all organization */
  // const totalRecord = await countQueryCondition(insurancePolicyImpactQuery);

  // return sendResponse(res, 200, insurancePolicyImpactRecord, totalRecord);
};

/**Function to delete a specific Insurance Policy Impact */
export const deleteInsurancePolicyImpact = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord(
    "insurance_policy_impact",
    id
  );
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Insurance Policy Impact",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
