import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  settingsUpdater,
  uniqueIdGenerator,
  encodeAndStringifyFields,
  getFirstCreatedAndAllOrganizationIds,
  decodeAndParseFields,
  getFilterConditions,
  getListingData,
  updateQueryBuilder,
  createQueryBuilder,
} from "../helper/general.js";
import Location from "../sequelize/LocationSchema.js";

/** Function to create or update Location */
// export const createUpdateLocation = async (req, res) => {
//   const { id, name, description, department } = req.body;

//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       Location,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "Location", `This user updated Location with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const unique_id = await uniqueIdGenerator(
//       req.body.organization,
//       department,
//       "OCL",
//       "location",
//       "unique_id",
//       "unique_id"
//     );
//     req.body.unique_id = unique_id;
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM location WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`INSERT INTO location (name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`,
//           [name, encodedDescription, req.user.sessionid, org, req.body.unique_id]);
//         await insertActivityLog(req.user.sessionid, "create", "Location", `This user created a new Location '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

// /** Function to view all or single Location */
// export const viewLocation = async (req, res) => {
//   const { id } = req.params;
//   const condition = await whereCondition({
//     table: "location",
//     page: req.query.page,
//     all: req.query.all,
//     pageSize: req.query.pageSize,
//     filter: req.query.filter,
//     id,
//     user: req.user,
//     grouped: req.query.grouped,
//   });

//   const searchFields = [
//     "location.name",
//     "location.description",
//     "users.name",
//     "organization.name"
//   ];
//   let searchCondition = await searchConditionRecord(req.query.search, searchFields);
//   const joins = [
//     { type: "left", targetTable: "users", onCondition: "users.id = location.created_by" },
//     { type: "left", targetTable: "organization", onCondition: "organization.id = location.organization" }
//   ];
//   const joinsRecord = await makeJoins(joins);

//   const fetchQuery = `SELECT location.*, users.name AS created_by, organization.name AS organization_name FROM location ${joinsRecord} WHERE location.deleted = 0 ${searchCondition} ${condition}`;
//   let [records] = await db.query(fetchQuery);

//   for (const record of records) {
//     record.description = await decodeSingle_statement(record.description);
//       if (req.query.grouped == "true") {
//       const [organizations] = await db.query(
//         `SELECT organization FROM location WHERE deleted = 0 AND name = ?`,
//         [record.name]
//       );
//       const arr = organizations.map((item) => item.organization);
//       record.organizations = arr;
//     }
//   }

//   const totalRecord = await countQueryCondition(fetchQuery);
//   return sendResponse(res, 200, records, totalRecord);
// };

// /** Function to delete Location */
// export const deleteLocation = async (req, res) => {
//   const { id } = req.params;
//   const deleteRecord = await deleteSettingRecord("location", id);
//   if (deleteRecord) {
//     await insertActivityLog(req.user.sessionid, "delete", "Location", id);
//     return sendResponse(res, 200, "Record deleted successfully");
//   } else {
//     return sendResponse(res, 404, "Record not found");
//   }
// };

export const createUpdateLocation = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }
  if (id) {
    const [findLocation] = await db.query("SELECT * FROM location WHERE id = ? AND deleted = 0", [id]);
    if (findLocation[0].is_static === 1) {
      return sendResponse(res, 404, "Restricted!");
    }
  }
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Location",
      "location",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(Location, req.body) : createQueryBuilder(Location, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "Location", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/**Function to view all and single Disability */
export const viewLocation = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "location");

  const searchTableName = ["location.name", "location.description", "CONCAT(users.name , ' ' , users.surname)"];
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = location.created_by",
    },
    {
      type: "left",
      targetTable: "location AS parent_location",
      onCondition: "parent_location.id = location.parent",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const LocationQuery = `SELECT location.unique_id, location.id, location.created_by as created_by_id, location.name,parent_location.name AS parent_name , location.description, users.name as created_by, users.surname as created_by_surname, users.profile as created_by_profile, location.organization as organizations, location.organization as organization, location.parent FROM location ${joinsRecord} WHERE location.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [Location] = await db.query(LocationQuery);

  Location = await getListingData(Location);

  // async function fetchSubChildren(parentId) {
  //   const [subChildren] = await db.query(`SELECT * FROM location WHERE deleted = 0 AND parent = ?`, [parentId]);

  //   // Only populate sub-children if any are found, and no need to recurse if not needed
  //   for (const child of subChildren) {
  //     child.description = await decodeSingle_statement(child.description);
  //     child.sub_children = await fetchSubChildren(child.id);
  //   }
  //   return subChildren;
  // }

  // const nestedLocation = [];

  // for (const item of Location) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (item.parent === null) {
  //     item.sub_children = await fetchSubChildren(item.id);
  //     nestedLocation.push(item);
  //   }
  // }

  const totalRecord = await countQueryCondition(LocationQuery);
  return sendResponse(res, 200, Location, totalRecord);
};

export const viewLocationDropDown = async (req, res) => {
  try {
    // First get ALL parent records (where parent is NULL)
    const parentQuery = `
        SELECT 
          id, 
          name, 
          parent, 
          organization
        FROM location
        WHERE deleted = 0 
        ORDER BY name ASC
      `;

    // Get all parent records without any LIMIT

    // Fetch all parent records
    let [allRecords] = await db.query(parentQuery);
    allRecords = await decodeAndParseFields(allRecords);

    // const parentCount = parseInt(req.query.pageSize) || 20; // Number of parents per page
    // const childrenPerParent = 5;
    // const currentPage = parseInt(req.query.page) || 1; // Current page number

    // // Adjust idCounter to start correctly for the current page
    // let startParentId = (currentPage - 1) * parentCount + 1;
    // const data = [];

    // for (let i = 0; i < parentCount; i++) {
    //     const parentId = startParentId + i; // Parent IDs increase sequentially
    //     data.push({
    //         id: parentId,
    //         name: `Parent ${parentId}`,
    //         parent: null,
    //         organization: [1],
    //     });

    //     // Generate children for the current parent
    //     for (let j = 0; j < childrenPerParent; j++) {
    //         data.push({
    //             id: parentId * 100 + (j + 1), // Unique child ID based on parent ID
    //             name: `Child ${j + 1} of Parent ${parentId}`,
    //             parent: parentId,
    //             organization: [1],
    //         });
    //     }
    // }

    return sendResponse(res, 200, allRecords);
  } catch (error) {
    console.error("Error fetching location dropdown data:", error);
    return sendResponse(res, 500, {
      error: "Internal Server Error",
      details:
        process.env.NODE_ENV === "development"
          ? {
              message: error.message,
              stack: error.stack,
            }
          : undefined,
    });
  }
};
export const getParentLocationList = async (req, res) => {
  let { filter } = req.query;
  filter = typeof filter === "string" ? JSON.parse(filter) : filter;
  let { organizations } = filter;
  if (!organizations || organizations.length == 0) {
    const [arrOrg] = await db.query(`SELECT id FROM organization WHERE deleted = 0`);
    organizations = arrOrg.map((item) => item.id);
  }
  organizations = typeof organizations == "string" ? JSON.parse(organizations) : organizations;
  const locationQuery = `
      SELECT *
      FROM location
      WHERE 
          ${organizations.map(() => `JSON_CONTAINS(organization, CAST(? AS JSON), '$')`).join(" AND ")}
          AND deleted = 0;
  `;

  const params = [...organizations];
  let [parentLocationList] = await db.query(locationQuery, params);
  parentLocationList = await decodeAndParseFields(parentLocationList);
  return sendResponse(res, 200, parentLocationList);
};

/**Function to delete a specific Disability */
export const deleteLocation = async (req, res) => {
  const { id } = req.params;
  const [findLocation] = await db.query("SELECT * FROM location WHERE id = ? AND deleted = 0", [id]);
  if (findLocation[0].is_static === 1) {
    return sendResponse(res, 404, "Restricted!");
  }
  const deleteRecordQuery = await deleteSettingRecord("location", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "location", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
