import asyncHandler from "express-async-handler";
import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  whereCondition,
  settingsUpdater,
  createQueryBuilder,
  searchConditionRecord,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  getFilterConditions,
  getListingData,
  getRecord,
} from "../helper/general.js";
import PermitLicense from "../sequelize/PermitLicenseSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create and update Permit License */
export const createUpdatedPermitLicense = asyncHandler(async (req, res) => {
  const { id, name, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(
      res,
      404,
      "Please Select at least one business Structure"
    );
  }

  const [checkNameWithOrganization] = await getRecord(
    "permit_license",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Permit License name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Permit License name already exist");
    }
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "PL",
      "permit_license",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(PermitLicense, req.body)
    : createQueryBuilder(PermitLicense, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(
    req.user.sessionid,
    status,
    "PermitLicense",
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record ${status} Successfully`);
});

/**Function to view all Permit License */
export const viewAllPermitLicense = asyncHandler(async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "permit_license"
  );

  // const condition = await whereCondition({
  //   table: "permit_license",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id: req.params.id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  /** If value come with any search condition then search that word */
  const searchTableName = [
    "permit_license.name",
    "permit_license.description",
    "CONCAT(createdUser.name , ' ' , createdUser.surname)",
  ];
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = permit_license.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = permit_license.organization",
    // },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all permit licenses */
  const permitLicenseDataFetchQuery = `SELECT permit_license.unique_id,permit_license.id,permit_license.created_by as created_by_id,permit_license.name,permit_license.description,createdUser.name as created_by ,createdUser.surname as created_by_surname ,createdUser.profile as created_by_profile ,permit_license.organization, permit_license.organization as organizations,permit_license.organization
  FROM permit_license  
  ${joinsRecord} 
  where permit_license.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  let [permitLicenseDataFetch] = await db.query(permitLicenseDataFetchQuery);

  permitLicenseDataFetch = await getListingData(permitLicenseDataFetch);

  // for (const item of permitLicenseDataFetch) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(`SELECT organization FROM permit_license WHERE deleted = 0 AND name = ?`, [
  //       item.name,
  //     ]);
  //     const arr = organizations.map((org) => org.organization);
  //     item.organizations = arr;
  //   }
  // }

  /**Count all Permit Licenses */
  const totalRecord = await countQueryCondition(permitLicenseDataFetchQuery);

  return sendResponse(res, 200, permitLicenseDataFetch, totalRecord);
});

/**Function to delete a specific Permit License */
export const deletePermitLicense = asyncHandler(async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("permit_license", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "Permit License", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
});
