import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import RoleOnTheProject from "../sequelize/RoleOnTheProjectSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create new RoleOnTheProject for employee  */
export const createUpdateRoleOnTheProject = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "RoleOnTheProject",
      "role_on_the_project",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(RoleOnTheProject, req.body)
    : createQueryBuilder(RoleOnTheProject, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "RoleOnTheProject", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/**Function to view all and single RoleOnTheProject */
export const viewRoleOnTheProject = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "role_on_the_project");

  const searchTableName = [
    "role_on_the_project.name",
    "role_on_the_project.description",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = role_on_the_project.created_by",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = role_on_the_project.department",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const RoleOnTheProjectQuery = `SELECT role_on_the_project.*,users.id AS created_by_id, users.name AS created_by, role_on_the_project.organization AS organizations , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM role_on_the_project ${joinsRecord} where role_on_the_project.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // return console.log(
  //   RoleOnTheProjectQuery,
  //   "RoleOnTheProjectQuery"
  // );
  let [RoleOnTheProjectRecord] = await db.query(RoleOnTheProjectQuery);

  RoleOnTheProjectRecord = await getListingData(RoleOnTheProjectRecord);

  /**Count all organization */
  const totalRecord = await countQueryCondition(RoleOnTheProjectQuery);

  return sendResponse(res, 200, RoleOnTheProjectRecord, totalRecord);
};

/**Function to delete a specific RoleOnTheProject */
export const deleteRoleOnTheProject = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("role_on_the_project", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "RoleOnTheProject", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
