import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import AccessRequests from "../sequelize/AccessRequestsSchema.js";

/**Function to create and update Alert   */
export const updateSoftwareAccess = async (req, res) => {
  const { id, type, organizationId, permission, organizations } = req.body;
  let query = "";
  let values = [];

  if (type === "role") {
    query = `UPDATE users SET organization = ? , permission = ? WHERE my_organization = ? AND role = ? AND special_permission = ?`;
    values = [organizations, JSON.stringify(permission), organizationId, id, 0];
    /**Also Update role permission column */
    await db.query(`UPDATE roles SET permission = ? WHERE id = ?`, [JSON.stringify(permission), id]);
  } else {
    query = `UPDATE users SET organization = ? , special_permission = 1 , permission = ? WHERE id = ?`;
    values = [organizations, JSON.stringify(permission), id];
  }

  await db.query(query, values);

  return sendResponse(res, 200, "Record updated successfully");
};

export const accessRequest = async (req, res) => {
  const { id } = req.body;
  let status = id ? "updated" : "created";

  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  const { query, values } = id
    ? updateQueryBuilder(AccessRequests, req.body)
    : createQueryBuilder(AccessRequests, req.body);

  const [result] = await db.query(query, values);

  await insertActivityLog(req.user.sessionid, status, "Access Request", id ? id : result.insertId);
  if (result?.insertId || result?.affectedRows) return sendResponse(res, 200, `Record ${status} Successfully`);
  return sendResponse(res, 400, `Cannot ${status} record`);
};

export const getAccessRequests = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "access_requests",
    user: req.user,
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = ["access_requests.access_type", "access_requests.reason", "access_requests.status"];

  const searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "users.id = access_requests.created_by",
    },
    {
      type: "left",
      targetTable: "sidebar AS module",
      onCondition: "sidebar.id = access_requests.module_id",
    },
    {
      type: "left",
      targetTable: "sidebar AS subModule",
      onCondition: "sidebar.id = access_requests.sub_module_id",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = access_requests.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = access_requests.department",
    },
  ];
  const joinCondition = await makeJoins(joins);
  const accessRequestsQuery = `SELECT access_requests.* , module.name AS module_name , subModule.name AS sub_module_name . department.name AS department_name , organization.name AS organization_name , CONCAT(createdUser.name , ' ' , createdUser.surname) AS created_by_name , createdUser.profile AS created_by_profile FROM access_requests ${joinCondition} WHERE access_requests.deleted = 0 ${searchCondition} ${condition}`;

  const accessRequests = await db.query(accessRequestsQuery);

  const totalRecord = await countQueryCondition(accessRequestsQuery);

  return sendResponse(res, 200, accessRequests, totalRecord);
};
