import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  insertNotification,
  makeJoins,
  searchConditionRecord,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import StakeholderActivityScheduling from "../sequelize/StakeholderActivitySchedulingSchema.js";

export const createUpdateActivityScheduling = async (req, res) => {
  const { id, department } = req.body;

  let status = id ? "Updated" : "Created";
  // const activityOwner = req.body.activity_owner;

  if (department) {
    req.body.organization = (
      await getOrganizationAccordingToDepartment(department)
    )[0].organization;
  }
  // if (activityOwner) {
  //   const [user] = await db.query(
  //     `SELECT * FROM users WHERE id = ${activityOwner}`
  //   );
  //   if (user[0].password) {
  //     // console.log("Hi");
  //     // subject, message, user, messageType, sender;
  //     await insertNotification(
  //       "Stakeholder Activity Scheduling",
  //       `This user ${status} a activity schedule`,
  //       Number(activityOwner),
  //       "text",
  //       req.user.sessionid
  //     );
  //   } else {
  //     const [teams] = await db.query(`SELECT * FROM teams WHERE deleted = 0`);
  //     for (const team of teams) {
  //       let teamMembers = JSON.parse(team.team_members);
  //       // console.log(teamMembers);
  //       // console.log(team.team_leader);
  //       if (teamMembers.includes(activityOwner)) {
  //         await insertNotification(
  //           "Stakeholder Activity Scheduling",
  //           `This user ${status} a activity schedule`,
  //           Number(team.team_leader),
  //           "text",
  //           req.user.sessionid
  //         );
  //         break;
  //       }
  //     }
  //   }
  // }
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  if(!id) {
    const unique_id = await uniqueIdGenerator(
      req.body.organization ,
      department,
      "StakeholderActivityScheduling",
      "stakeholder_activity_scheduling",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }

  req.body = await encodeAndStringifyFields(req.body);
  
  let { query, values } = id
    ? updateQueryBuilder(StakeholderActivityScheduling, req.body)
    : createQueryBuilder(StakeholderActivityScheduling, req.body);
    
  let [result] = await db.query(query, values);

  await insertActivityLog(
    req.user.sessionid,
    status,
    "Stakeholder Activity Scheduling",
    id ? id : result?.insertId
  );
  return sendResponse(res, 200, `Record ${status} successfully`);
};

export const getStakeholderActivityScheduling = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "stakeholder_activity_scheduling",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
    grouped: req.query.grouped,
    groupBy: req.query.groupBy,
  });
  const searchTableName = [
    "stakeholder_activity_scheduling.engagement_plan",
    "stakeholder_activity_scheduling.engagement_details",
    "stakeholder_activity_scheduling.engagement_method",
    "stakeholder_activity_scheduling.engagement_plan_objective",
    "stakeholder_activity_scheduling.frequency_of_engagement",
    "stakeholder_activity_scheduling.responsible_person",
    // "stakeholder_activity_scheduling.agenda",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = stakeholder_activity_scheduling.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition:
        "organization.id = stakeholder_activity_scheduling.organization",
    },
    {
      type: "left",
      targetTable: "stakeholder_engagement_plan",
      onCondition:
        "stakeholder_engagement_plan.id = stakeholder_activity_scheduling.stakeholder",
    },
    {
      type: "left",
      targetTable: "stakeholder_identification",
      onCondition:
        "stakeholder_identification.id = stakeholder_activity_scheduling.identification_id",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const activitySchedulingQuery = `SELECT stakeholder_activity_scheduling.* ,stakeholder_engagement_plan.stakeholder_name AS stakeholder_name, stakeholder_engagement_plan.engagement_start_date, users.name As created_by_name , users.surname AS created_by_surname , users.profile AS created_by_profile , organization.name AS organization_name FROM stakeholder_activity_scheduling ${joinCondition} WHERE stakeholder_activity_scheduling.deleted = 0  ${searchCondition} ${condition}`;

  let [activitySchedulingList] = await db.query(activitySchedulingQuery);

  activitySchedulingList = await decodeAndParseFields(activitySchedulingList);

  for (const element of activitySchedulingList) {
    const stakeholderId = element.stakeholder_name;
    const engagement_details = element?.engagement_details || [];

    for (let record of engagement_details) {
      const agendaList = record?.agenda || [];
       //allocated_to
      for (let agenda of agendaList) {
        if (agenda.allocated_to) {
          const [employee] = await db.query(
            `SELECT id , CONCAT(name , ' ' , surname) as name FROM users WHERE deleted = '0' AND id = ${agenda.allocated_to}`
          );
            agenda.allocated_to_name = employee[0]?.name;
        }
      }
       //host 
       if(record.host){
        const [host] = await db.query(
          `SELECT id , CONCAT(name , ' ' , surname) as name FROM users WHERE deleted = '0' AND id  = ${record.host}`
        );
         record.host_name = host[0]?.name
       }
     

      //participants
      const participants = record?.participants || [];
      let employeeList = [];
      if (participants.length > 0) {
        [employeeList] = await db.query(
          `SELECT id , CONCAT(name , ' ' , surname) as name FROM users WHERE deleted = '0' AND id IN(${participants})`
        );
      }
      const participants_name = employeeList.map((e) => e.name);
      record.participants_name = participants_name;
    }

    const id = !isNaN(Number(stakeholderId));

    if (id) {
      const [user] = await db.query(
        `SELECT CONCAT(name , ' ' , surname) AS name ,id  , profile  from users where id = ${Number(
          stakeholderId
        )}`
      );
      element.stakeholder_person_id = user[0]?.id;
      element.stakeholder_person_name = user[0]?.name;
      element.stakeholder_person_profile = user[0]?.profile;
    } else {
      element.stakeholder_person_name = stakeholderId;
    }
  }

  const totalRecord = await countQueryCondition(activitySchedulingQuery);

  return sendResponse(res, 200, activitySchedulingList, totalRecord);
};

export const deleteActivityScheduling = async (req, res) => {
  const { id } = req.params;
  await deleteRecord(StakeholderActivityScheduling, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Stakeholder Activity Scheduling",
    id
  );

  return sendResponse(res, 200, "Record deleted successfully");
};
