import db from "../db-config.js";

import { sendResponse } from "../helper/wrapper.js";

import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

import {
  countQueryCondition,
  decodeAndParseFields,
  encodeAndStringifyFields,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  whereCondition,
} from "../helper/general.js";

import SurveyResponse from "../sequelize/SurveyResponseSchema.js";

export const createUpdateSurveyResponse = async (req, res) => {
  const { id } = req.body;
  let status = id ? "Updated" : "Created";

  req.body = await encodeAndStringifyFields(req.body);

  const { query, values } = id
    ? updateQueryBuilder(SurveyResponse, req.body)
    : createQueryBuilder(SurveyResponse, req.body);

  await db.query(query, values);
  await insertActivityLog(req.user.sessionid, "create", "Survey Response", id);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const getSurveyResponse = async (req, res) => {
  const { id } = req.params;

  const condition = await whereCondition({
    table: "survey_response",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    // user: req.user,
  });

  const searchTableName = [
    "survey_response.name",
    "survey_response.email",
    "survey_response.phone",
    "survey_response.values",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = survey_response.user_id",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const surveyResponseQuery = `SELECT survey_response.*  , survey_response.name as user_name, CONCAT(users.name , ' ' , users.surname )  AS internal_user_name, users.profile AS internal_user_profile , users.email AS internal_user_email , users.phone AS internal_user_phone FROM survey_response ${joinCondition} WHERE survey_response.deleted = 0 AND survey_response.response_values IS NOT NULL ${searchCondition} ${condition}`;

  // console.log(surveyResponseQuery);

  let [surveyResponse] = await db.query(surveyResponseQuery);

  surveyResponse = await decodeAndParseFields(surveyResponse);
  for (const data of surveyResponse) {
    let [questions] = await db.query(
      `SELECT * FROM survey_questions WHERE survey_id = ?`,
      [data.survey_id]
    );
    questions = await decodeAndParseFields(questions);
    data.questions = questions;
    data.total = data.is_declared == 1 ? data.total : null;
    data.label = data.is_declared == 1 ? data.label : null;
    data.start_end = data.is_declared == 1 ? data.start_end : null;

    // data.labels =
  }
  const totalRecord = await countQueryCondition(surveyResponseQuery);

  return sendResponse(res, 200, surveyResponse, totalRecord);
};

export const deleteSurveyResponse = async (req, res) => {
  const { id } = req.params;
  await db.query(SurveyResponse, id);
  await insertActivityLog(req.user.sessionid, "delete", "Survey Response", id);
  return sendResponse(res, 200, "Record deleted successfully");
};
