import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getRecord,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import WasteDescription from "../sequelize/WasteDescriptionSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update WasteDescription */
export const createUpdateWasteDescription = async (req, res) => {
  const { id, name, description, organization } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "WasteDescription",
      "waste_description",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "waste_description",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "WasteDescription name already exist");
    } else if (!id) {
      return sendResponse(
        res,
        400,
        "WasteDescription name name  already exist"
      );
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(WasteDescription, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "WasteDescription",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(WasteDescription, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "WasteDescription",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(
  //     WasteDescription,
  //     req.body.organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(req.user.sessionid, "update", "WasteDescription", `This user updated WasteDescription with id: ${id}`);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(`SELECT name FROM waste_description WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
  //     if (checkName.length === 0) {
  //       const unique_id = await uniqueIdGenerator(
  //         org,
  //         req?.body?.department,
  //         "WD",
  //         "waste_description",
  //         "unique_id",
  //         "unique_id"
  //       );
  //       await db.query(`INSERT INTO waste_description (name, description, created_by, organization, unique_id) VALUES (?, ?,?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
  //       await insertActivityLog(req.user.sessionid, "create", "WasteDescription", `This user created a new WasteDescription '${name}' for organization ${org}`);
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single WasteDescription */
export const viewWasteDescription = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "waste_description"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "waste_description.name",
    "waste_description.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = waste_description.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let wasteDescriptionQuery = `SELECT 
  waste_description.*, 
  waste_description.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM waste_description
${joinsRecord} 
WHERE waste_description.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [wasteDescription] = await db.query(wasteDescriptionQuery);
  wasteDescription = await getListingData(wasteDescription);
  /**Count all organization */
  const totalRecord = await countQueryCondition(wasteDescriptionQuery);
  return sendResponse(res, 200, wasteDescription, totalRecord);

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "waste_description",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "waste_description.name",
  //   "waste_description.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = waste_description.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = waste_description.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT waste_description.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM waste_description ${joinsRecord} WHERE waste_description.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM waste_description WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete WasteDescription */
export const deleteWasteDescription = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("waste_description", id);
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "WasteDescription",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
