import mysql2 from "mysql2";
import dotenv from "dotenv";
dotenv.config();

const {
  DATABASE_HOST = "192.168.1.49",
  DATABASE_USER = "root",
  DATABASE_PASSWORD = "root",
  DATABASE_NAME = "harmony_help3",
} = process.env;

const config = {
  host: DATABASE_HOST,
  user: DATABASE_USER,
  password: DATABASE_PASSWORD,
  database: DATABASE_NAME,
};

// Create a connection pool
const db = mysql2.createPool(config).promise();
// Save the original query method
const originalQuery = db.query;

// The nameMapper object you provided
const nameMapper = {
  activity_notes: "activity_discussion_name",
  audit_scheduling: "name",
  asset: "asset_name",
  assets: "asset_name",
  attendance_recording_docs: "title",
  competency_assessment: "assessment_name",
  // contractor_appointments: "appointment_type.name",
  contractor_appointments_docs: "title",
  contractor_audit_scheduling_docs: "title",
  contractor_incident: "incident_title",
  contractor_incident_docs: "title",
  contractor_meeting: "meeting_title",
  contractor_meeting_notes: "meeting_discussion_name",
  contractor_ncr_recording: "name_of_legislation",
  contractor_permit_license: "title",
  contractor_permit_license_docs: "title",
  contractor_pre_site_docs: "title",
  contractor_questionnaire_docs: "title",
  contractor_registration: "contractor_name",
  contractor_risk_assessment: "risk_name",
  contractor_risk_register: "risk_register_name",
  contractor_safe_working_docs: "title",
  contractor_site_access_docs: "title",
  custom_action_creation: "task_title",
  custom_task_creation: "task_title",
  document_repository: "document_name",
  effectiveness_outcome: "employee_id",
  feedback_collection: "method_name",
  fire_equipment_register: "equipment_name",
  incident: "incident_title",
  incident_docs: "title",
  // infrastructure_technical_form: "name_of_police_station",
  insurance_claims_submission: "claimant_name",
  insurance_claim_docs: "title",
  investigation_docs: "title",
  knowledge_management_recording: "title",
  // legislation_doc: "document_title",
  meeting: "meeting_title",
  meeting_notes: "meeting_discussion_name",
  ncr_recording: "customer_name",
  objective_setting: "objective_name",
  ohs_file_requirement: "title",
  operational_risk: "risk_register_name",
  permit_license_docs: "title",
  policy: "policy_title",
  pre_site_response: "title",
  project_registration: "project_title",
  project_registration_docs: "title",
  questionnaire_response: "title",
  questions: "question_title",
  safety_incident: "state_name",
  security_incident_form: "specify_name",
  sops: "sop_name",
  // stakeholder_activity_scheduling: "activity_title",
  stakeholder_classification: "stakeholder_category",
  stakeholder_engagement_plan: "engagement_plan_name",
  strategic_risk: "risk_register_name",
  strategic_risk_identification: "risk_name",
  survey_questions: "question_title",
  tactical_risk: "risk_register_name",
  tactical_risk_identification: "risk_name",
  training_need_analysis: "training_name",
  bcp_management: "plan_name",
};

// Function to build the select query
export async function buildSelectQuery(tableName) {
  // Check if the table is in the nameMapper, if not, return empty string

  if (nameMapper[tableName]) {
    return `${nameMapper[tableName]} AS name`;
  }
  return "";
}

const modifiedDb = {
  async query(query, values) {
    const tableMatch = query.match(/FROM\s+(\S+)/i);
    const groupByCheck = query.match(/GROUP BY\s+(\S+)/i);
    const countCheck = query.match(/COUNT\(\*\)/i);
    const tableName = tableMatch ? tableMatch[1] : "";

    if (tableName && !groupByCheck && !countCheck) {
      const mappedFields = await buildSelectQuery(tableName);

      if (
        mappedFields !== "" &&
        (query.includes("SELECT") || query.includes("select"))
      ) {
        if (!mappedFields.includes(".")) {
          query = query.replace(
            " FROM ",
            `, ${tableName}.${mappedFields} FROM `
          );
          query = query.replace(
            " from ",
            `, ${tableName}.${mappedFields} FROM `
          );
        } else {
          query = query.replace(" FROM ", `, ${mappedFields} FROM `);
          query = query.replace(" from ", `, ${mappedFields} FROM `);
        }
      }
    }
    // console.log(query, values);

    return originalQuery.call(db, query, values);
  },
};

Object.assign(db, modifiedDb);

export default db;

`
SELECT investigation.*,
           incident.incident_title AS incident_title_name,
           involved_user.name AS involved_name,
           involved_user.profile AS involved_profile,
           involved_user.unique_id AS involved_employee_number,
           involved_user.gender AS involved_gender,
           involved_user.age AS involved_age,
           involved_user.phone AS involved_contact_details,
           involved_user.current_address AS involved_address,
           involved_user.department AS involved_department,
           involved_user_department.name AS involved_department_name,
           involved_user.role AS involved_role,
           involved_user_role.name AS involved_role_name,
           involved_user_role.year_of_experience AS involved_years_experience,
           supervisor_user.name AS supervisor_person_name,
           supervisor_user.role AS supervisor_role,
           supervisor_user.unique_id AS supervisor_employee_number,
           supervisor_user.phone AS supervisor_telephone_number,
           supervisor_user.organization AS supervisor_organization,
           supervisors_organization.name AS supervisor_business_structure,
           supervisor_user_role.name AS supervisor_role_name,
           CONCAT(investigator_user.name , ' ' , investigator_user.surname) AS investigation_lead_name,
           investigator_user.profile AS investigation_lead_profile,
           CONCAT(she_representative_user.name , ' ' , she_representative_user.surname)  AS she_representative_lead_name,
           she_representative_user.profile AS she_representative_lead_profile,
           created_user.name AS created_by_name,
           created_user.surname AS created_by_surname,
           organization.name AS organization_name,
           department.name AS department_name
    , incident.incident_title AS name FROM investigation
     LEFT JOIN incident_category ON investigation.recording_incident_category = incident_category.id LEFT JOIN department ON investigation.department = department.id LEFT JOIN organization ON investigation.organization = organization.id LEFT JOIN users as involved_user ON investigation.involved_person = involved_user.id LEFT JOIN users as supervisor_user ON investigation.supervisor_person = supervisor_user.id LEFT JOIN users as investigator_user ON investigation.investigation_lead = investigator_user.id LEFT JOIN users as she_representative_user ON investigation.she_representative_lead = she_representative_user.id LEFT JOIN users as created_user ON investigation.created_by = created_user.id LEFT JOIN roles as involved_user_role ON involved_user.role = involved_user_role.id LEFT JOIN roles as supervisor_user_role ON supervisor_user.role = supervisor_user_role.id LEFT JOIN department as involved_user_department ON involved_user.department = involved_user_department.id LEFT JOIN organization as supervisors_organization ON supervisor_user.my_organization = supervisors_organization.id LEFT JOIN incident ON incident.id = investigation.incident_title
    WHERE investigation.deleted = 0  `;
