const clientFields = ["name", "surname", "email", "password", "organization"];

async function defaultImport(data) {
  const {
    sequelize,
    sidebar,
    clientData: { name, surname, email, password, organization },
  } = data;
  for (const key of clientFields) {
    if (!data?.clientData[key]) {
      throw new Error(`Missing required parameter: ${key}`);
    }
  }
  const t = await data.sequelize.transaction();
  try {
    await sequelize.authenticate();
    console.log("Connection has been established successfully.");
    // Add data to sidebar table
    await sequelize.models.Sidebar.bulkCreate(sidebar, {
      validate: true,
      ignoreDuplicates: true,
      transaction: t,
    });

    // Add data to organization table
    const organizationData = await sequelize.models.Organization.create(
      {
        name: organization,
        level: "1",
      },
      {
        transaction: t,
      }
    );

    //create permission for user for created organization for those sidebar module whose access is provided

    const permission = [];
    sidebar.forEach((item) => {
      permission.push({
        sidebarId: item.id,
        permissions: {
          [organizationData.id]: {
            view: true,
            edit: true,
            delete: true,
            create: true,
          },
        },
      });
    });

    // Add data to users table
    await sequelize.models.User.create(
      {
        name: name,
        surname: surname,
        email: email,
        password: password,
        my_organization: organizationData.id,
        organization: JSON.stringify([organizationData.id]),
        permission: JSON.stringify(permission),
        unique_id: "SR0001",
        unique_id_status: "automatic",
        notification_sender: "[]",
        organization_access: `[${organizationData.id}]`,
        view_type: "all",
        is_super_admin: 1,
      },
      {
        transaction: t,
      }
    );
    await t.commit();
    return "DEFAULT IMPORT SUCCESSFUL";
  } catch (error) {
    await t.rollback();
    console.log(error);
    console.error("ERROR FROM DEFAULT IMPORT");
  }
}

export default defaultImport;
