// Include Excel.js library
import Excel from "exceljs";
import path from "path";
import db from "../db-config.js";
import asyncHandler from "express-async-handler";
import { whereCondition, storeError } from "./general.js";

export const strategicRiskAssessmentExcel = asyncHandler(async (req, res) => {
  try {
    // Create a new workbook
    const workbook = new Excel.Workbook();

    const gray = "808080";
    const yellow = "FFFF00";
    const green = "90EE90";
    const blue = "4467C4";
    const red = "FF0000";

    // Likelihood
    const fetchValues1 = [
      "100",
      "90",
      "80",
      "70",
      "60",
      "50",
      "40",
      "30",
      "20",
      "10",
      "1",
    ];
    // Consequence
    const fetchValues2 = [
      "9.0",
      "10.0",
      "29.0",
      "30.0",
      "44.0",
      "45.0",
      "59.0",
      "60.0",
      "79.0",
      "80.0",
      "99.0",
    ];

    const getResult = async (inherentLikelihood, inherentConsequences) => {
      const { id } = req.params;
      const condition = await whereCondition({
        table: "strategic_risk_identification",
        page: req.query.page,
        all: req.query.all,
        pageSize: req.query.pageSize,
        filter: req.query.filter,
        id,
        grouped: req.query.grouped,
        user: req.user,
      });

      const [result] = await db.query(
        `SELECT strategic_risk_identification.inherent_risk_rating from strategic_risk_identification WHERE  strategic_risk_identification.inherent_likelihood = ${inherentLikelihood} AND  strategic_risk_identification.inherent_consequence = ${inherentConsequences} AND strategic_risk_identification.deleted = 0 ${condition}`
      );
      return result[0]?.inherent_risk_rating;
    };

    // Add a worksheet
    const worksheet = workbook.addWorksheet("ENHANCED ERM METHODOLOGY");

    // Add the provided headers and categories
    const data = [
      [
        "Cat",
        "%",
        "ENHANCED ERM METHODOLOGY (Heat Map using minimax point values)",
      ],
      ["E", "100%", "", "", "", "", "", "", "", "", "", "", ""],
      ["", "90%", "", "", "", "", "", "", "", "", "", "", ""],
      ["D", "80%", "", "", "", "", "", "", "", "", "", "", ""],
      ["", "70%", "", "", "", "", "", "", "", "", "", "", ""],
      ["", "60%", "", "", "", "", "", "", "", "", "", "", ""],
      ["", "50%", "", "", "", "", "", "", "", "", "", "", ""],
      ["C", "40%", "", "", "", "", "", "", "", "", "", "", ""],
      ["", "30%", "", "", "", "", "", "", "", "", "", "", ""],
      ["", "20%", "", "", "", "", "", "", "", "", "", "", ""],
      ["B", "10%", "", "", "", "", "", "", "", "", "", "", ""],
      ["A", "1%", "", "", "", "", "", "", "", "", "", "", ""],
      [
        "MiniMax Points",
        "",
        "9.0",
        "10.0",
        "29.0",
        "30.0",
        "44.0",
        "45.0",
        "59.0",
        "60.0",
        "79.0",
        "80.0",
        "99.0",
      ],
      ["Category", ""],
    ];

    // Add data to the worksheet
    data.forEach((row) => {
      worksheet.addRow(row);
    });

    for (let i = 2; i < 13; i++) {
      for (let j = 3; j < 14; j++) {
        const toStore = await getResult(
          fetchValues1[i - 2],
          fetchValues2[j - 3]
        );

        worksheet.getCell(i, j).value = toStore === undefined ? "" : toStore;
      }
    }

    worksheet.mergeCells("C1:M1");
    worksheet.mergeCells("A2:A3");
    worksheet.getCell("A2").alignment = { vertical: "middle" };
    worksheet.mergeCells("A4:A7");
    worksheet.getCell("A4").alignment = { vertical: "middle" };
    worksheet.mergeCells("A8:A10");
    worksheet.getCell("A8").alignment = { vertical: "middle" };

    worksheet.getCell("A1").alignment = { horizontal: "center" };
    worksheet.getCell("B1").alignment = { horizontal: "center" };
    worksheet.getCell("C1").alignment = { horizontal: "center" };

    worksheet.mergeCells("A13:B13");
    worksheet.getCell("A13").alignment = { horizontal: "center" };
    worksheet.mergeCells("A14:B14");
    worksheet.getCell("A14").alignment = { horizontal: "center" };

    worksheet.getCell("C14").value = 7;
    worksheet.getCell("D14").value = 6;
    worksheet.getCell("E14").value = 5;

    worksheet.mergeCells("F14:G14");
    worksheet.getCell("F14").value = 4;
    worksheet.getCell("F14").alignment = { horizontal: "center" };
    worksheet.mergeCells("H14:I14");
    worksheet.getCell("H14").value = 3;
    worksheet.getCell("H14").alignment = { horizontal: "center" };
    worksheet.mergeCells("J14:K14");
    worksheet.getCell("J14").value = 2;
    worksheet.getCell("J14").alignment = { horizontal: "center" };
    worksheet.mergeCells("L14:M14");
    worksheet.getCell("L14").value = 1;
    worksheet.getCell("L14").alignment = { horizontal: "center" };

    worksheet.addRow([]);

    const data2 = [
      [
        "",
        "",
        "CURRENT METHODOLOGY",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "Priority",
        "From",
        "Below",
      ],
      ["", "E", "III", "III", "II", "II", "I", "I", "I", "", "V", 0, 6],
      ["", "D", "IV", "III", "III", "II", "II", "I", "I", "", "IV", 6, 20],
      ["", "C", "IV", "IV", "III", "III", "II", "II", "I", "", "III", 20, 35],
      ["", "B", "V", "IV", "IV", "III", "III", "II", "II", "", "II", 35, 55],
      ["", "A", "V", "V", "IV", "IV", "III", "III", "II", "", "I", 55, 100],
      ["", "", 7, 6, 5, 4, 3, 2, 1],
    ];

    // Add data to the worksheet
    data2.forEach((row) => {
      worksheet.addRow(row);
    });

    // Red	#FF0000
    // Lime	#00FF00
    // Blue	#0000FF
    // Yellow #FFFF00

    worksheet.mergeCells("C16:E16");
    worksheet.getCell("C16").alignment = { horizontal: "center" };

    // Define the file path where you want to save the Excel file

    for (let i = 3; i < 14; i++) {
      let rowIndex = 2;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 5) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 8) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 3;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 9) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 4;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 10) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 5;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 8) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 11) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 6;
      if (i <= 3) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      } else if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 9) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 12) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 7;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      } else if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 10) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",

          fgColor: { argb: blue }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 8;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      } else if (i <= 8) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 12) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 9;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      } else if (i <= 10) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 10;
      if (i <= 5) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 11;
      if (i <= 9) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      }
    }

    for (let i = 3; i < 14; i++) {
      let rowIndex = 12;
      worksheet.getCell(rowIndex, i).fill = {
        type: "pattern",
        pattern: "solid",
        fgColor: { argb: gray }, // Blue color
      };
    }

    for (let i = 3; i < 10; i++) {
      let rowIndex = 17;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      }
      if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 10; i++) {
      let rowIndex = 18;
      if (i <= 3) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      }
      if (i <= 5) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 7) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 10; i++) {
      let rowIndex = 19;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      }
      if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else if (i <= 8) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: red }, // Blue color
        };
      }
    }

    for (let i = 3; i < 10; i++) {
      let rowIndex = 20;
      if (i <= 3) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      }
      if (i <= 5) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 7) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      }
    }

    for (let i = 3; i < 10; i++) {
      let rowIndex = 21;
      if (i <= 4) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: gray }, // Blue color
        };
      }
      if (i <= 6) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: green }, // Blue color
        };
      } else if (i <= 8) {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: blue }, // Blue color
        };
      } else {
        worksheet.getCell(rowIndex, i).fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: yellow }, // Blue color
        };
      }
    }

    for (let i = 11; i < 14; i++) {
      let rowIndex = 17;
      worksheet.getCell(rowIndex, i).fill = {
        type: "pattern",
        pattern: "solid",
        fgColor: { argb: gray }, // Blue color
      };
    }

    for (let i = 11; i < 14; i++) {
      let rowIndex = 18;
      worksheet.getCell(rowIndex, i).fill = {
        type: "pattern",
        pattern: "solid",
        fgColor: { argb: green }, // Blue color
      };
    }

    for (let i = 11; i < 14; i++) {
      let rowIndex = 19;
      worksheet.getCell(rowIndex, i).fill = {
        type: "pattern",
        pattern: "solid",
        fgColor: { argb: blue }, // Blue color
      };
    }

    for (let i = 11; i < 14; i++) {
      let rowIndex = 20;
      worksheet.getCell(rowIndex, i).fill = {
        type: "pattern",
        pattern: "solid",
        fgColor: { argb: yellow }, // Blue color
      };
    }

    for (let i = 11; i < 14; i++) {
      let rowIndex = 21;
      worksheet.getCell(rowIndex, i).fill = {
        type: "pattern",
        pattern: "solid",
        fgColor: { argb: red }, // Blue color
      };
    }

    worksheet.eachRow({ includeEmpty: false }, function (row, rowNumber) {
      // Iterate over each cell in the row
      row.eachCell({ includeEmpty: false }, function (cell, colNumber) {
        // Set the border for each cell
        cell.border = {
          top: { style: "thin" }, // Thin top border
          left: { style: "thin" }, // Thin left border
          bottom: { style: "thin" }, // Thin bottom border
          right: { style: "thin" }, // Thin right border
          // You can adjust the style to 'medium' or 'thick' for darker or bolder borders
        };
        cell.alignment = {
          wrapText: true,
          horizontal: "center",
          vertical: "middle",
        };
        cell.font = {
          bold: true,
        };
      });
    });

    const cwd = process.cwd();

    const filePath = path.join(
      cwd,
      "public",
      "excel",
      "Strategic_Risk_Assessment.xlsx"
    );
    await workbook.xlsx.writeFile(filePath);

    return res.status(200).json({
      status: true,
      message: "Excel file created successfully",
      data: `${process.env.HARMONY_BACKEND_URL}/excel/Strategic_Risk_Assessment.xlsx`,
    });
  } catch (error) {
    storeError(error);
    return res.status(500).json({
      status: false,
      message: error.message,
    });
  }
});
