import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCrisisType, deleteCrisisType, viewCrisisType } from "../controller/crisisTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  crisis type
 *   description: API operations for managing  crisis type
 */
const crisisTypeRoutes = Router();

/**
 * @swagger
 * /api/crisisType/create-update-crisis-type:
 *   post:
 *     summary: Create or update a  crisis type
 *     tags: [ crisis type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
crisisTypeRoutes.post(
  "/create-update-crisis-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 447 , "crisis_type")(req, res, next);
  },
  controllerWrapper(createUpdateCrisisType)
);

/**
 * @swagger
 * /api/crisisType/get-crisis-type:
 *   get:
 *     summary: Get all records of  crisis type
 *     tags: [ crisis type]
 */
crisisTypeRoutes.get(
  "/get-crisis-type",
  verifyToken,
  sideBarPermissionCheck("view", 447, "crisis_type"),
  controllerWrapper(viewCrisisType)
);

/**
 * @swagger
 * /api/crisisType/get-crisis-type/{id}:
 *   get:
 *     summary: Get a specific record of  crisis type
 *     tags: [ crisis type]
 */
crisisTypeRoutes.get(
  "/get-crisis-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 447, "crisis_type"),
  controllerWrapper(viewCrisisType)
);

/**
 * @swagger
 * /api/crisisType/delete-crisis-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  crisis type
 *     tags: [ crisis type]
 */
crisisTypeRoutes.delete(
  "/delete-crisis-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 447, "crisis_type"),
  controllerWrapper(deleteCrisisType)
);

export default crisisTypeRoutes;