import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateEquipment, deleteEquipment, viewEquipment } from "../controller/equipmentController.js";
import { controllerWrapper } from "../helper/wrapper.js";

/**
 * @swagger
 * tags:
 *   name: Equipment
 *   description: API operations for managing Equipment
 */
const equipmentRoutes = Router();

/**
 * @swagger
 * /api/equipment/create-update-equipment:
 *   post:
 *     summary: Create or update a Equipment
 *     tags: [Equipment]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
equipmentRoutes.post(
  "/create-update-equipment",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 362 , "equipment")(req, res, next);
  },
  controllerWrapper(createUpdateEquipment)
);

/**
 * @swagger
 * /api/equipment/get-equipment:
 *   get:
 *     summary: Get all records of Equipment
 *     tags: [Equipment]
 */
equipmentRoutes.get(
  "/get-equipment",
  verifyToken,
  sideBarPermissionCheck("view", 362, "equipment"),
  controllerWrapper(viewEquipment)
);

/**
 * @swagger
 * /api/equipment/get-equipment/{id}:
 *   get:
 *     summary: Get a specific record of Equipment
 *     tags: [Equipment]
 */
equipmentRoutes.get(
  "/get-equipment/:id",
  verifyToken,
  sideBarPermissionCheck("view", 362, "equipment"),
  controllerWrapper(viewEquipment)
);

/**
 * @swagger
 * /api/equipment/delete-equipment/{id}:
 *   delete:
 *     summary: Delete a specific record of Equipment
 *     tags: [Equipment]
 */
equipmentRoutes.delete(
  "/delete-equipment/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 362, "equipment"),
  controllerWrapper(deleteEquipment)
);

export default equipmentRoutes;