import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateQualityIncidentType,
  deleteQualityIncidentType,
  viewQualityIncidentType,
} from "../controller/qualityIncidentTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  quality incident type
 *   description: API operations for managing  quality incident type
 */
const qualityIncidentTypeRoutes = Router();

/**
 * @swagger
 * /api/qualityIncidentType/create-update-quality-incident-type:
 *   post:
 *     summary: Create or update a  quality incident type
 *     tags: [ quality incident type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
qualityIncidentTypeRoutes.post(
  "/create-update-quality-incident-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      413,
      "quality_incident_type"
    )(req, res, next);
  },
  controllerWrapper(createUpdateQualityIncidentType)
);

/**
 * @swagger
 * /api/qualityIncidentType/get-quality-incident-type:
 *   get:
 *     summary: Get all records of  quality incident type
 *     tags: [ quality incident type]
 */
qualityIncidentTypeRoutes.get(
  "/get-quality-incident-type",
  verifyToken,
  sideBarPermissionCheck("view", 413, "quality_incident_type"),
  controllerWrapper(viewQualityIncidentType)
);

/**
 * @swagger
 * /api/qualityIncidentType/get-quality-incident-type/{id}:
 *   get:
 *     summary: Get a specific record of  quality incident type
 *     tags: [ quality incident type]
 */
qualityIncidentTypeRoutes.get(
  "/get-quality-incident-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 413, "quality_incident_type"),
  controllerWrapper(viewQualityIncidentType)
);

/**
 * @swagger
 * /api/qualityIncidentType/delete-quality-incident-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  quality incident type
 *     tags: [ quality incident type]
 */
qualityIncidentTypeRoutes.delete(
  "/delete-quality-incident-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 413, "quality_incident_type"),
  controllerWrapper(deleteQualityIncidentType)
);

export default qualityIncidentTypeRoutes;
