import { Router } from "express";
import { controllerWrapper } from "../helper/wrapper.js";
import { getRegulatoryBody } from "../controller/regulatoryBodyController.js";
import { verifyToken } from "../helper/tokenVerify.js";

/**
 * @swagger
 * tags:
 *   name:  Regulatory Bodies
 *   description: API operations for managing  regulatory bodies
 */
const regulatoryBodyRoutes = Router();

/**
 * @swagger
 * /api/regulatoryBody/get-regulatory-body:
 *   get:
 *     summary: Get all records of Regulatory Body
 *     tags: [ Regulatory Bodies]
 */
regulatoryBodyRoutes.get("/get-regulatory-body", verifyToken, controllerWrapper(getRegulatoryBody));

export default regulatoryBodyRoutes;
