import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { createFolder, deleteFolder, getFolderByParent, getFolderDetails, updateFolder } from "../controller/repositoryController.js";

const RepositoryRouter = Router();

RepositoryRouter.post("/create-folder",verifyToken,controllerWrapper(createFolder));
RepositoryRouter.post("/update-folder",verifyToken,controllerWrapper(updateFolder));
RepositoryRouter.get("/get-folder-details/:id",verifyToken,controllerWrapper(getFolderDetails));
RepositoryRouter.get("/get-folder-by-parent/:id",verifyToken,controllerWrapper(getFolderByParent));
RepositoryRouter.delete("/delete-folder/:id",verifyToken,controllerWrapper(deleteFolder));

export default RepositoryRouter