import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createSecurityIncidentForm,
  deleteSecurityIncidentForm,
  getSecurityIncidentForm,
} from "../controller/securityIncidentFormController.js";

const securityIncidentFromRoutes = Router();

/**
 * @swagger
 * tags:
 *   name: Security Incidents
 *   description: API operations for managing security incidents
 */

/**
 * @swagger
 * /api/securityIncidentForm/create-security-incident-form:
 *   post:
 *     summary: Create a new security incident form
 *     tags: [Security Incidents]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               category_id:
 *                 type: integer
 *               incident_id:
 *                 type: integer
 *               date_of_incident:
 *                 type: string
 *                 format: date
 *               time_of_incident:
 *                 type: string
 *                 format: time
 *               location_of_incident:
 *                 type: string
 *               incident_reference_no:
 *                 type: string
 *               type_of_security_incident:
 *                 type: string
 *               description_of_incident:
 *                 type: string
 *               committed_by_whom:
 *                 type: string
 *               specify_name:
 *                 type: string
 *               name_of_employee:
 *                 type: string
 *               employee_id:
 *                 type: string
 *               employee_type:
 *                 type: string
 *               what_kind_of_theft:
 *                 type: string
 *               estimated_cost:
 *                 type: number
 *                 format: float
 *               estimated_replacement_cost:
 *                 type: number
 *                 format: float
 *               was_case_reported_to_insurer:
 *                 type: string
 *                 enum: ["0", "1"]
 *               name_of_insurer:
 *                 type: string
 *               is_transnet_or_third_party_insurer:
 *                 type: string
 *               date_reported_to_insurer:
 *                 type: string
 *                 format: date
 *               reported_by_who_to_insurer:
 *                 type: string
 *               claim_number:
 *                 type: string
 *               who_received_the_claim:
 *                 type: string
 *               was_case_reported_to_saps:
 *                 type: string
 *                 enum: ["0", "1"]
 *               name_of_police_station_saps:
 *                 type: string
 *               case_number_saps:
 *                 type: string
 *               name_of_contact_person_saps:
 *                 type: string
 *               contact_details_saps:
 *                 type: string
 *               investigation_officer_saps:
 *                 type: string
 *               date_of_investigation_saps:
 *                 type: string
 *                 format: date
 *               time_of_investigation_saps:
 *                 type: string
 *                 format: time
 *               person_who_reported_investigation_saps:
 *                 type: integer
 *               any_arrest_made:
 *                 type: string
 *                 enum: ["0", "1"]
 *               how_many_arrested:
 *                 type: integer
 *               employee_type_arrest:
 *                 type: string
 *               who_was_involved_in_arrest:
 *                 type: integer
 *               police_officers_involved:
 *                 type: string
 *                 enum: ["0", "1"]
 *               community_members_involved:
 *                 type: string
 *               any_items_recovered:
 *                 type: string
 *                 enum: ["0", "1"]
 *               recovered_items:
 *                 type: string
 *               was_there_forced_entry:
 *                 type: string
 *                 enum: ["0", "1"]
 *               description_of_forced_entry:
 *                 type: string
 *               asset_number:
 *                 type: string
 *               location_of_asset:
 *                 type: string
 *               time_of_discovery:
 *                 type: string
 *                 format: time
 *               person_reporting_break_in:
 *                 type: string
 *               witness_of_break_in:
 *                 type: string
 *               tools_used:
 *                 type: string
 *               value_involved:
 *                 type: number
 *                 format: float
 *               value_recovered:
 *                 type: number
 *                 format: float
 *               comments:
 *                 type: string
 *               form_completed_by:
 *                 type: string
 *               designation:
 *                 type: string
 *               signature:
 *                 type: string
 *               date:
 *                 type: string
 *                 format: date
 *               organization:
 *                 type: integer
 *               department:
 *                 type: integer
 *           example:
 *             category_id: 1
 *             incident_id: 101
 *             date_of_incident: "2024-07-12"
 *             time_of_incident: "14:30"
 *             location_of_incident: "Building A"
 *             incident_reference_no: "INC123456"
 *             type_of_security_incident: "Theft"
 *             description_of_incident: "Laptop stolen"
 *             committed_by_whom: "Unknown"
 *             specify_name: "N/A"
 *             name_of_employee: "John Doe"
 *             employee_id: "E12345"
 *             employee_type: "Full-Time"
 *             what_kind_of_theft: "Equipment"
 *             estimated_cost: 1500.00
 *             estimated_replacement_cost: 2000.00
 *             was_case_reported_to_insurer: "1"
 *             name_of_insurer: "XYZ Insurance"
 *             is_transnet_or_third_party_insurer: "Transnet"
 *             date_reported_to_insurer: "2024-07-13"
 *             reported_by_who_to_insurer: "John Doe"
 *             claim_number: "CLM123"
 *             who_received_the_claim: "XYZ Insurance"
 *             was_case_reported_to_saps: "1"
 *             name_of_police_station_saps: "Main Police Station"
 *             case_number_saps: "SAPS123"
 *             name_of_contact_person_saps: "Officer Smith"
 *             contact_details_saps: "123-456-7890"
 *             investigation_officer_saps: "Officer Johnson"
 *             date_of_investigation_saps: "2024-07-14"
 *             time_of_investigation_saps: "15:00"
 *             person_who_reported_investigation_saps: 1
 *             any_arrest_made: "0"
 *             how_many_arrested: 0
 *             employee_type_arrest: "N/A"
 *             who_was_involved_in_arrest: 0
 *             police_officers_involved: "1"
 *             community_members_involved: "None"
 *             any_items_recovered: "0"
 *             recovered_items: "None"
 *             was_there_forced_entry: "1"
 *             description_of_forced_entry: "Door was broken"
 *             asset_number: "AST001"
 *             location_of_asset: "Office"
 *             time_of_discovery: "16:00"
 *             person_reporting_break_in: "John Doe"
 *             witness_of_break_in: "Jane Doe"
 *             tools_used: "Screwdriver"
 *             value_involved: 1500.00
 *             value_recovered: 0.00
 *             comments: "Security needs to improve."
 *             form_completed_by: "John Doe"
 *             designation: "Security Officer"
 *             signature: "JohnD"
 *             date: "2024-07-12"
 *             organization: 1
 *             department: 2
 */
securityIncidentFromRoutes.post(
  "/create-security-incident-form",
  verifyToken,
  // (req, res, next) => {
  //   sideBarPermissionCheck(
  //     req.body.id ? "edit" : "create",
  //     190,
  //     "security_incident_form"
  //   )(req, res, next);
  // },
  controllerWrapper(createSecurityIncidentForm)
);

/**
 * @swagger
 * /api/securityIncidentForm/get-security-incident-form/{id}:
 *   get:
 *     summary: Get a specific security incident form by ID
 *     tags: [Security Incidents]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: integer
 *         required: true
 *         description: The ID of the security incident form
 *     responses:
 *       200:
 *         description: Security incident form data
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 category_id:
 *                   type: integer
 *                 incident_id:
 *                   type: integer
 *                 date_of_incident:
 *                   type: string
 *                   format: date
 *                 time_of_incident:
 *                   type: string
 *                   format: time
 *                 location_of_incident:
 *                   type: string
 *                 incident_reference_no:
 *                   type: string
 *                 type_of_security_incident:
 *                   type: string
 *                 description_of_incident:
 *                   type: string
 *                 committed_by_whom:
 *                   type: string
 *                 specify_name:
 *                   type: string
 *                 name_of_employee:
 *                   type: string
 *                 employee_id:
 *                   type: string
 *                 employee_type:
 *                   type: string
 *                 what_kind_of_theft:
 *                   type: string
 *                 estimated_cost:
 *                   type: number
 *                   format: float
 *                 estimated_replacement_cost:
 *                   type: number
 *                   format: float
 *                 was_case_reported_to_insurer:
 *                   type: string
 *                   enum: ["0", "1"]
 *                 name_of_insurer:
 *                   type: string
 *                 is_transnet_or_third_party_insurer:
 *                   type: string
 *                 date_reported_to_insurer:
 *                   type: string
 *                   format: date
 *                 reported_by_who_to_insurer:
 *                   type: string
 *                 claim_number:
 *                   type: string
 *                 who_received_the_claim:
 *                   type: string
 *                 was_case_reported_to_saps:
 *                   type: string
 *                   enum: ["0", "1"]
 *                 name_of_police_station_saps:
 *                   type: string
 *                 case_number_saps:
 *                   type: string
 *                 name_of_contact_person_saps:
 *                   type: string
 *                 contact_details_saps:
 *                   type: string
 *                 investigation_officer_saps:
 *                   type: string
 *                 date_of_investigation_saps:
 *                   type: string
 *                   format: date
 *                 time_of_investigation_saps:
 *                   type: string
 *                   format: time
 *                 person_who_reported_investigation_saps:
 *                   type: integer
 *                 any_arrest_made:
 *                   type: string
 *                   enum: ["0", "1"]
 *                 how_many_arrested:
 *                   type: integer
 *                 employee_type_arrest:
 *                   type: string
 *                 who_was_involved_in_arrest:
 *                   type: integer
 *                 police_officers_involved:
 *                   type: string
 *                   enum: ["0", "1"]
 *                 community_members_involved:
 *                   type: string
 *                 any_items_recovered:
 *                   type: string
 *                   enum: ["0", "1"]
 *                 recovered_items:
 *                   type: string
 *                 was_there_forced_entry:
 *                   type: string
 *                   enum: ["0", "1"]
 *                 description_of_forced_entry:
 *                   type: string
 *                 asset_number:
 *                   type: string
 *                 location_of_asset:
 *                   type: string
 *                 time_of_discovery:
 *                   type: string
 *                   format: time
 *                 person_reporting_break_in:
 *                   type: string
 *                 witness_of_break_in:
 *                   type: string
 *                 tools_used:
 *                   type: string
 *                 value_involved:
 *                   type: number
 *                   format: float
 *                 value_recovered:
 *                   type: number
 *                   format: float
 *                 comments:
 *                   type: string
 *                 form_completed_by:
 *                   type: string
 *                 designation:
 *                   type: string
 *                 signature:
 *                   type: string
 *                 date:
 *                   type: string
 *                   format: date
 *                 organization:
 *                   type: integer
 *                 department:
 *                   type: integer
 *             example:
 *               category_id: 1
 *               incident_id: 101
 *               date_of_incident: "2024-07-12"
 *               time_of_incident: "14:30"
 *               location_of_incident: "Building A"
 *               incident_reference_no: "INC123456"
 *               type_of_security_incident: "Theft"
 *               description_of_incident: "Laptop stolen"
 *               committed_by_whom: "Unknown"
 *               specify_name: "N/A"
 *               name_of_employee: "John Doe"
 *               employee_id: "E12345"
 *               employee_type: "Full-Time"
 *               what_kind_of_theft: "Equipment"
 *               estimated_cost: 1500.00
 *               estimated_replacement_cost: 2000.00
 *               was_case_reported_to_insurer: "1"
 *               name_of_insurer: "XYZ Insurance"
 *               is_transnet_or_third_party_insurer: "Transnet"
 *               date_reported_to_insurer: "2024-07-13"
 *               reported_by_who_to_insurer: "John Doe"
 *               claim_number: "CLM123"
 *               who_received_the_claim: "XYZ Insurance"
 *               was_case_reported_to_saps: "1"
 *               name_of_police_station_saps: "Main Police Station"
 *               case_number_saps: "SAPS123"
 *               name_of_contact_person_saps: "Officer Smith"
 *               contact_details_saps: "123-456-7890"
 *               investigation_officer_saps: "Officer Johnson"
 *               date_of_investigation_saps: "2024-07-14"
 *               time_of_investigation_saps: "15:00"
 *               person_who_reported_investigation_saps: 1
 *               any_arrest_made: "0"
 *               how_many_arrested: 0
 *               employee_type_arrest: "N/A"
 *               who_was_involved_in_arrest: 0
 *               police_officers_involved: "1"
 *               community_members_involved: "None"
 *               any_items_recovered: "0"
 *               recovered_items: "None"
 *               was_there_forced_entry: "1"
 *               description_of_forced_entry: "Door was broken"
 *               asset_number: "AST001"
 *               location_of_asset: "Office"
 *               time_of_discovery: "16:00"
 *               person_reporting_break_in: "John Doe"
 *               witness_of_break_in: "Jane Doe"
 *               tools_used: "Screwdriver"
 *               value_involved: 1500.00
 *               value_recovered: 0.00
 *               comments: "Security needs to improve."
 *               form_completed_by: "John Doe"
 *               designation: "Security Officer"
 *               signature: "JohnD"
 *               date: "2024-07-12"
 *               organization: 1
 *               department: 2
 */
securityIncidentFromRoutes.get(
  "/get-security-incident-form/:id",
  verifyToken,
  // sideBarPermissionCheck("view", 190, "security_incident_form"),
  controllerWrapper(getSecurityIncidentForm)
);

/**
 * @swagger
 * /api/securityIncidentForm/delete-security-incident-form/{id}:
 *   delete:
 *     summary: Delete a specific security incident form by ID
 *     tags: [Security Incidents]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: integer
 *         required: true
 *         description: The ID of the security incident form to delete
 *     responses:
 *       200:
 *         description: Security incident form successfully deleted
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *             example:
 *               message: "Security incident form successfully deleted"
 */
securityIncidentFromRoutes.delete(
  "/delete-security-incident-form/:id",
  verifyToken,
  // sideBarPermissionCheck("delete", 190, "security_incident_form"),
  controllerWrapper(deleteSecurityIncidentForm)
);

export default securityIncidentFromRoutes;
