import { Router } from "express";
import { controllerWrapper } from "../helper/wrapper.js";
import { getStructuredVehicleParts, getVehicleParts } from "../controller/vehiclePartsController.js";
import { verifyToken } from "../helper/tokenVerify.js";

/**
 * @swagger
 * tags:
 *   name:  Vehicle Parts
 *   description: API operations for managing vehicle parts
 */
const vehiclePartsRoutes = Router();

/**
 * @swagger
 * /api/vehicleParts/get-vehicle-parts:
 *   get:
 *     summary: Get all records of Vehicle Parts
 *     tags: [ Vehicle Parts ]
 */
vehiclePartsRoutes.get("/get-vehicle-parts/:id?", verifyToken, controllerWrapper(getVehicleParts));
/**
 * @swagger
 * /api/vehicleParts/get-vehicle-parts:
 *   get:
 *     summary: Get all records of Vehicle Parts
 *     tags: [ Vehicle Parts ]
 */
vehiclePartsRoutes.get("/get-structured-vehicle-parts/:id?", verifyToken, controllerWrapper(getStructuredVehicleParts));

export default vehiclePartsRoutes;
