import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateWasteManifest,
  deleteWasteManifest,
  viewWasteManifest,
} from "../controller/wasteManifestController.js";

/**
 * @swagger
 * tags:
 *   name: WasteManifest
 *   description: API operations for managing WasteManifest
 */
const wasteManifestRoutes = Router();

/**
 * @swagger
 * /api/wasteManifest/create-update-waste-manifest:
 *   post:
 *     summary: Create or update a WasteManifest
 *     tags: [WasteManifest]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
wasteManifestRoutes.post(
  "/create-update-waste-manifest",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      311,
      "waste_manifest"
    )(req, res, next);
  },
  controllerWrapper(createUpdateWasteManifest)
);

/**
 * @swagger
 * /api/wasteManifest/get-waste-manifest:
 *   get:
 *     summary: Get all records of WasteManifest
 *     tags: [WasteManifest]
 */
wasteManifestRoutes.get(
  "/get-waste-manifest",
  verifyToken,
  sideBarPermissionCheck("view", 311, "waste_manifest"),
  controllerWrapper(viewWasteManifest)
);

/**
 * @swagger
 * /api/wasteManifest/get-waste-manifest/{id}:
 *   get:
 *     summary: Get a specific record of WasteManifest
 *     tags: [WasteManifest]
 */
wasteManifestRoutes.get(
  "/get-waste-manifest/:id",
  verifyToken,
  sideBarPermissionCheck("view", 311, "waste_manifest"),
  controllerWrapper(viewWasteManifest)
);

/**
 * @swagger
 * /api/wasteManifest/delete-waste-manifest/{id}:
 *   delete:
 *     summary: Delete a specific record of WasteManifest
 *     tags: [WasteManifest]
 */
wasteManifestRoutes.delete(
  "/delete-waste-manifest/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 311, "waste_manifest"),
  controllerWrapper(deleteWasteManifest)
);

export default wasteManifestRoutes;
