import fs from "fs";
import path from "path";
import db from "../db-config.js";
import { DIR } from "../constants/constants.js";

export const createRootDirectories = async () => {
  try {
    const { root, ddrm } = DIR;
    const publicDirectory = path.join(process.cwd(), "public");

    const ddrmDirectory = path.join(publicDirectory, root, ddrm);
    fs.mkdirSync(ddrmDirectory, { recursive: true });

    // Set read-only permissions (755) for 'root' and 'ddrm'
    // const rootDirectory = path.join(publicDirectory, root);
    // fs.chmodSync(rootDirectory, "755"); // 755 for read-only
    // fs.chmodSync(ddrmDirectory, "755");

    const [organizations] = await db.query(`SELECT id FROM organization WHERE deleted = 0`);

    for (const organization of organizations) {
      const organizationId = organization.id;
      const [existDir] = await db.query(
        `SELECT * FROM repository WHERE name = 'root' AND organization = ${organizationId}`
      );

      if (existDir.length === 0) {
        const [directory] = await db.query(
          `INSERT INTO repository (name, organization, type, url, is_locked) VALUES ('${root}', ${organizationId}, 'folder', '${root}',1)`
        );

        const [ddrmDirectory] = await db.query(
          `INSERT INTO repository (name, organization, type, url, parent_id,is_locked) VALUES ('${ddrm}', ${organizationId}, 'folder', '${root}/${ddrm}', ${directory.insertId},1)`
        );
      }
    }

    console.log('✅ Directories "root/ddrm" created successfully.');
  } catch (error) {
    console.error("❌ Error creating protected directories:", error);
  }
};
// createRootDirectories();
