// AuditSchema.js
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import Department from "./DepartmentSchema.js";

import { DataTypes } from "sequelize";
import Sidebar from "./SidebarSchema.js";
import Currency from "./CurrencySchema.js";

const evaluationToolsArr = ["Not Applicable", "Not Added", "Added"];

const AuditSchema = sequelize.define(
  "Audit",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING(250),
    },
    type: {
      type: DataTypes.INTEGER,
    },
    linked_to: {
      type: DataTypes.STRING(255),
    },
    module: {
      type: DataTypes.INTEGER,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    sub_module: {
      type: DataTypes.INTEGER,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    record_name: {
      type: DataTypes.INTEGER,
    },
    planned_start_date: {
      type: DataTypes.DATE,
    },
    planned_end_date: {
      type: DataTypes.DATE,
    },
    want_to_repeat: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    when: {
      type: DataTypes.STRING(255),
    },
    cycles: {
      type: DataTypes.STRING(255),
    },
    source: {
      type: DataTypes.INTEGER,
    },
    lead_person: {
      type: DataTypes.INTEGER,
    },
    members: {
      type: DataTypes.TEXT("long"),
    },
    owner: {
      type: DataTypes.STRING(255),
    },
    participants: {
      type: DataTypes.TEXT("long"),
    },
    scope: {
      type: DataTypes.TEXT("long"),
    },
    critical_business: {
      type: DataTypes.STRING(255),
    },
    financial_resource: {
      type: DataTypes.STRING(255),
    },
    value: {
      type: DataTypes.INTEGER,
    },
    currency: {
      type: DataTypes.INTEGER,
      references: {
        model: Currency,
        key: "id",
      },
    },
    opening_meeting_agenda: {
      type: DataTypes.DATE,
    },
    closing_meeting_agenda: {
      type: DataTypes.DATE,
    },
    evaluation_tool: {
      type: DataTypes.ENUM(evaluationToolsArr),
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
    },
  },
  {
    tableName: "audit",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// await AuditSchema.sync({ alter: true });
// console.log('SYNC DONE');

export default AuditSchema;
