import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import ContractorInvestigation from "./ContractorInvestigationSchema.js";

const ContractorInvestigationDocs = sequelize.define(
  "ContractorInvestigationDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    contractor_investigation_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorInvestigation,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_investigation_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorInvestigationDocs.belongsTo(ContractorInvestigation, {
  foreignKey: "contractor_investigation_id",
  as: "ContractorInvestigation",
});
// console.log(await ContractorInvestigationDocs.sync({ alter: true }));

export default ContractorInvestigationDocs;
