import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import ContractorPermitLicense from "./ContractorPermitLicenseSchema.js";
import Repository from "./RepositorySchema.js";

//! not in use
const ContractorPermitLicenseDocs = sequelize.define(
  "ContractorPermitLicenseDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    contractor_permit_license_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorPermitLicense,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    image: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_permit_license_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorPermitLicenseDocs.belongsTo(ContractorPermitLicense, {
  foreignKey: "contractor_permit_license_id",
  as: "contractorPermitLicense",
});
// console.log(await ContractorPermitLicenseDocs.sync({ alter: true }));

export default ContractorPermitLicenseDocs;
