import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import ContractorRiskRegister from "./ContractorRiskRegisterSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";

const ContractorRiskAssessment = sequelize.define(
  "ContractorRiskAssessment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    risk_register: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRiskRegister,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // risk_owner: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    // },
    risk_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    risk_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    impact_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    causes_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    inherent_likelihood: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    inherent_consequence: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    inherent_risk_rating: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    inherent_risk_ranking: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    is_control_known: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "value (0 or 1)",
    },
    control_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    control_design_intent: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    control_effectiveness: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    // control_owner: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    // },
    control_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    residual_risk_rating: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    residual_risk_ranking: {
      type: DataTypes.STRING(255),
    },
    opportunity_identification: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    opportunity_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    priority_confirmation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "contractor_risk_assessment",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorRiskAssessment.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});
ContractorRiskAssessment.belongsTo(ContractorRiskRegister, {
  foreignKey: "risk_register",
  as: "RiskRegister",
});
ContractorRiskAssessment.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorRiskAssessment.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorRiskAssessment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorRiskAssessment.belongsTo(ProjectRegistration, {
  foreignKey: "project",
  as: "Project",
});

ContractorRiskAssessment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await ContractorRiskAssessment.sync({alter : true}))

export default ContractorRiskAssessment;
