import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import Repository from "./RepositorySchema.js";

const ContractorSafeWorking = sequelize.define(
  "ContractorSafeWorking",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "Pending",
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    public_url: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    signing_method: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Digital",
    },
    document: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "contractor_safe_working",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorSafeWorking.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});
ContractorSafeWorking.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorSafeWorking.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorSafeWorking.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorSafeWorking.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await ContractorSafeWorking.sync({ alter: true }));

export default ContractorSafeWorking;
