import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import TrainingNeedAnalysis from "./TrainingNeedAnalysisSchema.js";
import Department from "./DepartmentSchema.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";

const ContractorTrainingSchedule = sequelize.define(
  "ContractorTrainingSchedule",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contractors: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    projects: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    training_program: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TrainingNeedAnalysis,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    venue_type: {
      type: DataTypes.ENUM("On-Site", "Off-Site"),
      allowNull: true,
    },
    facilitator_type: {
      type: DataTypes.ENUM("Internal", "External"),
      allowNull: true,
      defaultValue: "Internal",
    },
    internal_emp_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    company_name: {
      type: DataTypes.INTEGER,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      allowNull: true,
    },
    facilitator_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    training_provider: {
      type: DataTypes.ENUM("Internal", "External"),
      allowNull: true,
    },
    external_provider: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    internal_provider_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    provider_department: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    period: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    financial_year: {
      type: DataTypes.STRING(255),
      // reference removed from settings
      allowNull: true,
    },
    schedule_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    single_day: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    single_start_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    single_end_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    multiple_day: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    multiple_end_day: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    calendar_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    calendar_end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    schedule_time: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "contractor_training_schedule",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorTrainingSchedule.belongsTo(TrainingNeedAnalysis, {
  foreignKey: "training_program",
  as: "TrainingProgram",
});
ContractorTrainingSchedule.belongsTo(Department, {
  foreignKey: "internal_provider_department",
  as: "InternalProviderDepartment",
});

ContractorTrainingSchedule.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorTrainingSchedule.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorTrainingSchedule.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorTrainingSchedule.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await ContractorTrainingSchedule.sync({ alter: true }));
export default ContractorTrainingSchedule;
