import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";

const DDRM = sequelize.define(
  "DDRM",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    document: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    category: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    storage: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    meta_tags: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assign_with_roles: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assign_with_users: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    role_periods: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    users_periods: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    user_start_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    user_end_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    role_start_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    role_end_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    select_by: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,
    tableName: "ddrm",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

export default DDRM;

// console.log(await DDRM.sync({ alter: true }));
