import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";

const InfrastructureTechnicalForm = sequelize.define(
  "InfrastructureTechnicalForm",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    incident_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    incident_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    incident_severity: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [1, 2, 3, 4]
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    role_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    department: {
      type: DataTypes.STRING(250),
    },
    asset_type: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    asset_details: {
      type: DataTypes.JSON,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    asset_damage_details: {
      type: DataTypes.JSON,
    },
    form_submitted_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
    },
    date_of_submission: {
      type: DataTypes.DATEONLY,
    },
    notification: {
      type: DataTypes.JSON,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "infrastructure_technical_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

InfrastructureTechnicalForm.belongsTo(Incident, {
  foreignKey: "incident_id",
  as: "Incident",
});

InfrastructureTechnicalForm.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
InfrastructureTechnicalForm.belongsTo(User, {
  foreignKey: "form_submitted_by",
});
InfrastructureTechnicalForm.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
InfrastructureTechnicalForm.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await InfrastructureTechnicalForm.sync({ alter: true }));
export default InfrastructureTechnicalForm;
