import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import NameOfStandard from "./NameOfStandardSchema.js";
import Department from "./DepartmentSchema.js";
import Currency from "./CurrencySchema.js"
import Repository from "./RepositorySchema.js";
const NcrRecording = sequelize.define(
  "NcrRecording",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    ncr_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    raised_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    raised_by_employee_no: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_by_contact: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ncr_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_work: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_action_taken: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    legal_non_compliance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    system_non_conformance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    customer_non_compliance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    name_of_legislation: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    name_of_standard: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: NameOfStandard,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    customer_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    provision_of_the_requirement: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    standard_clause_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contravened_contract_clause: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    origin_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    specify_origin_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    type_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    specify_type_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ncr_categories: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    classification: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    internal_raised_business: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    internal_raised_against_business: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_raised_against_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_name_of_site: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    internal_location: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },

    internal_responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_employee_no: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    internal_date_raised: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    external_raised_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    external_contact_details: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    external_date_raised: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    external_due_date_resolve_ncr: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    external_responsible_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    corrective_action_title: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    corrective_action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    corrective_responsible_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    corrective_responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    corrective_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    corrective_due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    corrective_action_progress: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    corrective_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    preventative_action_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    preventative_action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    preventative_responsible_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    preventative_responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    preventative_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    preventative_due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    preventative_action_progress: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    preventative_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    human_resource_requirements: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    technological_resources: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_resource: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    amount: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    currency: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Currency,
        key: "id"
      }
    },
    necessary_corrective: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    new_risk: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    problem_been_removed: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    stop_certificate_used: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    stop_certificate_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    requirements_contravened: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    condition_of_stop_certificate: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recipient_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    recipient_role: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recipient_employee_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recipient_date_received: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    issuer_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    issuer_designation: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    issuer_contact_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    issuer_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    issuer_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    date_lifted: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    compliance_to_mitigation: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    lifting_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    signature_type: {
      type: DataTypes.ENUM("Electronic", "Manual"),
      allowNull: false,
      defaultValue: "Manual",
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    stop_certificate_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // reference from repository table
    },
    ncr_report_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // reference from repository table
    },
    corrective_action_been_raised: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    preventative_action_been_raised: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "ncr_recording",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
NcrRecording.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
NcrRecording.belongsTo(User, { foreignKey: "raised_by", as: "RaisedBy" });
NcrRecording.belongsTo(NameOfStandard, {
  foreignKey: "name_of_standard",
  as: "NameOfStandard",
});
NcrRecording.belongsTo(Organization, {
  foreignKey: "internal_raised_business",
  as: "InternalRaisedBusiness",
});
NcrRecording.belongsTo(Organization, {
  foreignKey: "internal_raised_against_business",
  as: "InternalRaisedAgainstBusiness",
});
NcrRecording.belongsTo(Department, {
  foreignKey: "internal_raised_against_department",
  as: "InternalRaisedAgainstDepartment",
});
NcrRecording.belongsTo(User, {
  foreignKey: "internal_responsible_person",
  as: "InternalResponsiblePerson",
});
NcrRecording.belongsTo(Department, {
  foreignKey: "corrective_responsible_department",
  as: "CorrectiveResponsibleDepartment",
});
NcrRecording.belongsTo(User, {
  foreignKey: "corrective_responsible_person",
  as: "CorrectiveResponsiblePerson",
});
NcrRecording.belongsTo(Department, {
  foreignKey: "preventative_responsible_department",
  as: "PreventativeResponsibleDepartment",
});
NcrRecording.belongsTo(User, {
  foreignKey: "preventative_responsible_person",
  as: "PreventativeResponsiblePerson",
});
NcrRecording.belongsTo(User, { foreignKey: "created_by", as: "CreatedBy" });
NcrRecording.belongsTo(User, { foreignKey: "updated_by", as: "UpdatedBy" });
// console.log(await NcrRecording.sync({ alter: true }));
export default NcrRecording;
