import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import CategoryType from "./CategoryTypeSchema.js";
import Incident from "./IncidentSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const NearMissReporting = sequelize.define(
  "NearMissReporting",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    person_reporting: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    near_miss_reporting_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    near_miss_actual_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    near_miss_classification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [1, 2, 3, 4] : reference {IncidentCategory Table}
    },
    immediate_action_taken: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    near_miss_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    severity: {
      type: DataTypes.ENUM("High", "Medium", "Low"),
      defaultValue: "Low",
    },
    probability: {
      type: DataTypes.ENUM("High", "Medium", "Low"),
      defaultValue: "Low",
    },
    requires_investigation: {
      type: DataTypes.ENUM("Yes", "No"),
      allowNull: "Yes",
    },
    investigation_outcome: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    action_taken: {
      type: DataTypes.INTEGER,
      allowNull: true,
      //reference:{Custom Action Creation Table}
    },
    near_miss_submission: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [{"user_id": 1, role: 1 , department: 1}]
    },
    notification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [{"user_id": 1, role: 1 , department: 1}]
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    save_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "near_miss_reporting",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

NearMissReporting.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
NearMissReporting.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
NearMissReporting.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
NearMissReporting.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await NearMissReporting.sync({ alter: true }));
export default NearMissReporting;
