import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const OhsFileRequirement = sequelize.define(
  "OhsFileRequirement",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    company_registration_no: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    coida_registration_no: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contact_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contact_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    site_address: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    postal_address: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    section_appointment: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    health_safety_representative: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    activities_rendered: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    commencement_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    completion_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    employees_on_site: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    female: {
      type: DataTypes.BIGINT,
      allowNull: true,
    },
    male: {
      type: DataTypes.BIGINT,
      allowNull: true,
    },
    people_with_disabilities: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "ohs_file_requirement",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

OhsFileRequirement.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});

OhsFileRequirement.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

OhsFileRequirement.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

OhsFileRequirement.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

OhsFileRequirement.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

// console.log(await OhsFileRequirement.sync({alter:true}))

export default OhsFileRequirement;
