import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import IssuingAuthority from "./IssuingAuthoritySchema.js";
import Organization from "./OrganizationSchema.js";
import PermitLicense from "./PermitLicenseSchema.js";
import Department from "./DepartmentSchema.js";

const PermitLicenseCompliance = sequelize.define(
  "PermitLicenseCompliance",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: PermitLicense,
        key: PermitLicense.primaryKeyAttribute,
      },
    },
    permit_license_category: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    permit_holder_type: {
      type: DataTypes.ENUM("personal", "business"),
      allowNull: true,
      defaultValue: "personal",
    },
    permit_holder: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
    },
    permit_license_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    issuing_authority: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: IssuingAuthority,
        key: "id",
      },
    },
    issue_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    effective_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    end_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    applicable_section_of_legislation: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    condition_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: Department.primaryKeyAttribute,
      },
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
  },
  {
    tableName: "permit_license_compliance",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

PermitLicenseCompliance.belongsTo(User, {
  foreignKey: "permit_holder",
  as: "PermitHolder",
});

PermitLicenseCompliance.belongsTo(IssuingAuthority, {
  foreignKey: "issuing_authority",
  as: "IssuingAuthority",
});

PermitLicenseCompliance.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

PermitLicenseCompliance.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

PermitLicenseCompliance.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await PermitLicenseCompliance.sync({ alter: true }));
export default PermitLicenseCompliance;
