import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const Policy = sequelize.define(
  "Policy",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    policy_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    new_sop: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    affected_sop: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    policy_title: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    document_classification: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    effective_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    next_review_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    last_review_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    policy_author: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    reference_no: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    policy_reviewer: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    policy_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },

    policy_reference: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_revision_history: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_approver: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    policy_purpose: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_scope: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_terms: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_abbreviations: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    roles_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_statement: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    document_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    document_reference_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    version_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    revision_effective_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    details_of_addition: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    revision_version_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },

    policy_status: {
      type: DataTypes.ENUM("draft", "complete"),
      allowNull: true,
      defaultValue: "draft",
    },
    current_status: {
      type: DataTypes.ENUM(
        "pending",
        "reviewing",
        "approval",
        "approved",
        "rejected"
      ),
      allowNull: false,
      defaultValue: "pending",
    },
    // key to store how many times the policy has been communicated(viewed) by the reviewers
    policy_communicated_count: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "policy",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

Policy.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

Policy.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

Policy.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

Policy.belongsTo(User, {
  foreignKey: "policy_author",
  as: "PolicyAuthor",
});

Policy.belongsTo(User, {
  foreignKey: "policy_owner",
  as: "PolicyOwner",
});

Policy.belongsTo(User, {
  foreignKey: "policy_approver",
  as: "PolicyApprover",
});

// console.log(await Policy.sync({ alter: true }));

export default Policy;
