import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import AuditTemplate from "./AuditTemplateSchema.js";
import User from "./UserSchema.js";

const Question = sequelize.define(
  "Question",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    audit_template_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: AuditTemplate,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    question_title: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    answer_type: {
      type: DataTypes.ENUM(
        "Multiple Choice",
        "Checkbox",
        "Dropdown",
        "Paragraph",
        "Linear Scale",
        "Date",
        "Time"
      ),
      allowNull: true,
    },
    answer_key: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    points: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    options: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    min: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    max: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    question_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    required: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },

    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "questions",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

Question.belongsTo(AuditTemplate, {
  foreignKey: "audit_template_id",
  as: "AuditTemplate",
});

Question.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

Question.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default Question;
