import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import StakeholderActivityScheduling from "./StakeholderActivitySchedulingSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import FeedbackContext from "./FeedbackContextSchema.js";
import Repository from "./RepositorySchema.js";

const StakeholderActivityRecording = sequelize.define(
  "StakeholderActivityRecording",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    stakeholder: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: StakeholderActivityScheduling,
        key: "id",
      },
    },
    engagement_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    engagement_method: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    engagement_plan_objective: {
      type: DataTypes.STRING(255),
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    frequency_of_engagement: {
      type: DataTypes.STRING(255),
    },
    responsible_person: {
      type: DataTypes.STRING(255),
    },
    approval_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "In Progress",
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "In Progress",
    },

    engagement_status: {
      type: DataTypes.ENUM("In Progress", "Complete"),
      allowNull: true,
      defaultValue: "In Progress",
    },
    is_feedback_received: {
      type: DataTypes.BOOLEAN,
    },
    feedback_status: {
      type: DataTypes.ENUM("Negative", "Positive", "Neutral"),
      defaultValue: "Positive",
    },
    feedback_context: {
      type: DataTypes.INTEGER,
      references: {
        model: FeedbackContext,
        key: FeedbackContext.primaryKeyAttribute,
      },
    },
    comment: {
      type: DataTypes.TEXT("long"),
    },
    department_affected: {
      type: DataTypes.INTEGER,
      references: {
        model: Department,
        key: Department.primaryKeyAttribute,
      },
    },
    feedback_description: {
      type: DataTypes.TEXT("long"),
    },
    feedback_tags: {
      type: DataTypes.TEXT("long"),
    },
    sentiment_rating: {
      type: DataTypes.ENUM(
        "Very Positive",
        "Positive",
        "Neutral",
        "Negative",
        "Very Negative"
      ),
      allowNull: true,
      defaultValue: "Neutral",
    },
    feedback_impact: {
      type: DataTypes.TEXT("long"),
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    feedback_priority: {
      type: DataTypes.ENUM("High", "Medium", "Low"),
    },
    feedback_impact_scope: {
      type: DataTypes.TEXT("long"),
    },
    // comments: {
    //   type: DataTypes.TEXT("long"),
    // },
    // send_to_employee: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      reference: {
        model: Repository,
        key: "id",
      },
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_approval: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "stakeholder_activity_recording",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

StakeholderActivityRecording.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

StakeholderActivityRecording.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

StakeholderActivityRecording.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

StakeholderActivityRecording.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await StakeholderActivityRecording.sync({ alter: true }));

export default StakeholderActivityRecording;
