import { DataTypes, INTEGER } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import EngagementMethod from "./EngagementMethodSchema.js";
import EngagementLevels from "./EngagementLevelsSchema.js";
import Currency from "./CurrencySchema.js";
import { EndFields } from "../constants/constants.js";
import StakeHolderIdentification from "./StakeholderIdentificationSchema.js";

const StakeholderEngagementPlan = sequelize.define(
  "StakeholderEngagementPlan",
  {
    classification_type: {
      type: DataTypes.STRING(255),
    },
    priority_level: {
      type: DataTypes.STRING(255),
    },
    stakeholder_category: {
      type: DataTypes.INTEGER,
    },
    stakeholder_name: {
      type: DataTypes.STRING(255),
      //references  from stakeholder identification can be
    },
    recommended_engagement_level: {
      type: DataTypes.STRING(255),
    },
    engagement_plan_name: {
      type: DataTypes.STRING(255),
    },
    engagement_plan_objectives: {
      type: DataTypes.STRING(255),
    },
    engagement_frequency: {
      type: DataTypes.STRING(255),
    },
    engagement_start_date: {
      type: DataTypes.DATEONLY,
    },
    no_of_cycles: {
      type: DataTypes.STRING(255),
    },
    engagement_methods: {
      type: DataTypes.STRING(255),
      // references: {
      //   model: EngagementMethod,
      //   key: "id",
      // },
      // changed to static value
    },
    engagement_level: {
      type: DataTypes.INTEGER,
      references: {
        model: EngagementLevels,
        key: "id",
      },
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    identification_id: {
      type: DataTypes.INTEGER,
      references: {
        model: StakeHolderIdentification,
        key: "id",
      },
    },
    responsible_person: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: "id",
      },
    },
    human_resource_requirements: {
      type: DataTypes.TEXT("long"),
    },
    technological_resources: {
      type: DataTypes.TEXT("long"),
    },
    type_of_resources: {
      type: DataTypes.STRING(255),
    },
    amount: {
      type: DataTypes.BIGINT,
    },
    currency: {
      type: DataTypes.INTEGER,
      references: {
        model: Currency,
        key: "id",
      },
    },
    ...EndFields,
  },
  {
    tableName: "stakeholder_engagement_plan",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await StakeholderEngagementPlan.sync({ alter: true }));

export default StakeholderEngagementPlan;
