import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import SurveyDesign from "./SurveyDesignSchema.js";

const SurveyQuestions = sequelize.define(
  "SurveyQuestions",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    survey_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: SurveyDesign,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    min: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
    },
    max: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
    },
    answer_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    automated_scores: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      defaultValue: null,
    },
    points: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
    },
    options: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      defaultValue: null,
    },
    question_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
    },
    question_title: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: null,
    },
    scoring_type: {
      type: DataTypes.ENUM("manual", "automated"),
      allowNull: true,
      defaultValue: "automated",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,

    tableName: "survey_questions",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SurveyQuestions.belongsTo(SurveyDesign, {
  foreignKey: "survey_id",
  as: "SurveyDesign",
});

export default SurveyQuestions;
