import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import FileClassification from "./FileClassificationSchema.js";
import TrainingAttendance from "./TrainingAttendanceRecordingSchema.js";
import Repository from "./RepositorySchema.js";

const TrainingAttendanceRecordingDocs = sequelize.define(
  "TrainingAttendanceRecordingDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    attendance_recording_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TrainingAttendance,
        key: "id",
      },
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    file: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(250),
    },
    classification: {
      type: DataTypes.INTEGER,
      references: {
        model: FileClassification,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,
    tableName: "attendance_recording_docs",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TrainingAttendanceRecordingDocs.belongsTo(FileClassification, {
  as: "classification_details",
  foreignKey: "classification",
});

FileClassification.hasMany(TrainingAttendanceRecordingDocs, {
  foreignKey: "classification",
  as: "classification_details",
});
// console.log(await TrainingAttendanceRecordingDocs.sync({ alter: true }));
export default TrainingAttendanceRecordingDocs;
