import { EndFields } from "../constants/constants.js";
import PPERepository from "./PPERepositorySchema.js";
import sequelize from "./sequelize.js";
import { DataTypes, Model } from "sequelize";
import User from "./UserSchema.js";

class UserPPERepository extends Model {}

UserPPERepository.init(
  {
    ppe_repository_id: {
      type: DataTypes.INTEGER,
      references: {
        model: PPERepository,
        key: PPERepository.primaryKeyAttribute,
      },
    },
    user_id: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
    },
    ...EndFields,
  },
  {
    tableName: "user_ppe_repository",
    sequelize,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await UserPPERepository.sync({ alter: true }));
export default UserPPERepository;
