import axios from "axios";
import fs from "fs";
import dotenv from "dotenv";

dotenv.config();

const TOKEN_FILE = "./token.json";


const loadTokens = () => {
  if (fs.existsSync(TOKEN_FILE)) {
    return JSON.parse(fs.readFileSync(TOKEN_FILE, "utf8"));
  }
  return {
    accessToken: null,
    refreshToken: process.env.ADOBE_SIGN_REFRESH_TOKEN,
  };
};

const saveTokens = (tokens) => {
  fs.writeFileSync(TOKEN_FILE, JSON.stringify(tokens, null, 2));
};

export const refreshAccessToken = async () => {
  const tokens = loadTokens();
  try {
    const response = await axios.post(process.env.ADOBE_IMS_URL, null, {
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      params: {
        grant_type: "refresh_token",
        client_id: process.env.ADOBE_SIGN_CLIENT_ID,
        client_secret: process.env.ADOBE_SIGN_CLIENT_SECRET,
        refresh_token: tokens.refreshToken,
      },
    });

    const newTokens = {
      accessToken: response.data.access_token,
      refreshToken: response.data.refresh_token || tokens.refreshToken, 
    };

    saveTokens(newTokens);
    return newTokens.accessToken;
  } catch (error) {
    console.error(
      "Error refreshing access token:",
      error.response?.data || error.message
    );
    throw error;
  }
};

export const getAccessToken = async () => {
  const tokens = loadTokens();
  if (!tokens.accessToken) {
    return await refreshAccessToken();
  }
  return tokens.accessToken;
};
