import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  getFirstCreatedAndAllOrganizationIds,
  uniqueIdGenerator,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import CollectionSite from "../sequelize/CollectionSiteSchema.js";

/** Function to create or update CollectionSite */
export const createUpdateCollectionSite = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "CollectionSite",
      "collection_site",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(CollectionSite, req.body)
    : createQueryBuilder(CollectionSite, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "CollectionSite", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateCollectionSite = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       CollectionSite,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "CollectionSite", `This user updated CollectionSite with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM collection_site WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`INSERT INTO collection_site (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
//         await insertActivityLog(req.user.sessionid, "create", "CollectionSite", `This user created a new CollectionSite '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single CollectionSite */
export const viewCollectionSite = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "collection_site");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "collection_site",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = ["collection_site.name", "collection_site.description", "users.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = collection_site.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = collection_site.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT collection_site.*, CONCAT(users.name, ' ', users.surname) AS created_by, collection_site.organization AS organizations FROM collection_site ${joinsRecord} WHERE collection_site.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //    if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM collection_site WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete CollectionSite */
export const deleteCollectionSite = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("collection_site", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "CollectionSite", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
