import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";
import EmployeeType from "../sequelize/EmployeeTypeSchema.js";

/**Function to create new Employee Type for employee  */
export const createUpdateEmployeeType = async (req, res) => {
  const { id, name, description, organization } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "EmployeeType",
      "employee_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "employee_type",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Employee Type name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Employee Type name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(EmployeeType, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "EmployeeType", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(EmployeeType, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "EmployeeType",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       200,
  //       "Please select at least one business structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     EmployeeType,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "EmployeeType",
  //     `This user Update Employee Type which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   /** Insert new record */
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the  employee type  already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM  employee_type  WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     // If record not found for that name with particular organization, insert the record
  //     if (checkNameWithOrganization.length === 0) {

  //         const unique_id = await uniqueIdGenerator(
  //           element,
  //           req.body?.department || null,
  //           "EmployeeType",
  //           "employee_type",
  //           "unique_id",
  //           "unique_id"
  //         );

  //       // Insert Employee Type details
  //       const insertEmployeeTypeQuery = `INSERT INTO  employee_type (name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`;
  //       await db.query(insertEmployeeTypeQuery, [
  //         name,
  //         encodedDescription,
  //         req.user.sessionid,
  //         element,
  //         unique_id
  //       ]);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "EmployeeType ",
  //         `This user created a new category '${name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all and single Employee Type */
export const viewEmployeeType = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "employee_type"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "employee_type.name",
    "employee_type.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = employee_type.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let employeeTypeQuery = `SELECT 
  employee_type.*, 
  employee_type.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM employee_type
${joinsRecord} 
WHERE employee_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [employeeType] = await db.query(employeeTypeQuery);
  employeeType = await getListingData(employeeType);
  /**Count all organization */
  const totalRecord = await countQueryCondition(employeeTypeQuery);
  return sendResponse(res, 200, employeeType, totalRecord);

  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: " employee_type ",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchTableName = [
  //   " employee_type .name",
  //   " employee_type .description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id =  employee_type .created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id =  employee_type .organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "department",
  //     onCondition: "department.id =  employee_type .department",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const EmployeeTypeQuery = `SELECT  employee_type .*,users.id AS created_by_id, users.name AS created_by, organization.name AS organization_name , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM  employee_type  ${joinsRecord} where  employee_type .deleted = 0 ${searchCondition} ${condition}`;
  // // return console.log(
  // //   EmployeeTypeQuery,
  // //   "EmployeeTypeQuery"
  // // );
  // let [EmployeeTypeRecord] = await db.query(EmployeeTypeQuery);

  // for (const item of EmployeeTypeRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM  employee_type  WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  // /**Count all organization */
  // const totalRecord = await countQueryCondition(EmployeeTypeQuery);

  // return sendResponse(res, 200, EmployeeTypeRecord, totalRecord);
};

/**Function to delete a specific Employee Type */
export const deleteEmployeeType = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord(" employee_type ", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "EmployeeType ", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
