import {
  countQueryCondition,
  decodeSingle_statement,
  deleteFile,
  deleteRecord,
  encodeSingle_statement,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import ExplosionBombForm from "../sequelize/ExplosionBombFormSchema.js";
import db from "../db-config.js";
import { createQueryBuilder } from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create Explosion Bomb Form  */

export const createExplosionBombForm = async (req, res) => {
  // console.log(req.body);
  const { id } = req.body;
  const sessionId = req.user.sessionid;
  let organizationId = req.body.organization;
  const { department, comments } = req.body;

  if (department) {
    const recordAccordingToOrganization = await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0]?.organization;
    if (organizationId) {
      req.body.organization = organizationId;
    }
  }

  req.body.comments = await encodeSingle_statement(comments);
  req.body.created_by = sessionId;
  const { query, values } = id
    ? updateQueryBuilder(ExplosionBombForm, req.body)
    : createQueryBuilder(ExplosionBombForm, req.body);
  const [createExplosionForm] = await db.query(query, values);
  if (!id && createExplosionForm.insertId === 0) {
    return sendResponse(res, 404, "Cannot create record");
  }

  await insertActivityLog(
    req.user.sessionid,
    "create",
    "Explosion Bomb Form",
    `This user created a new Explosion Bomb Form Record for organization ${organizationId}`
  );

  return sendResponse(res, 200, "Record created successfully");
};

export const getExplosionBombForm = async (req, res) => {
  const { type } = req.query;
  const { id } = req.params;
  const condition = await whereCondition({
    table: "explosion_bomb_form",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
    columnName: type,
  });
  const searchTableName = [
    "explosion_bomb_form.type_of_incident",
    "explosion_bomb_form.location",
    "explosion_bomb_form.immediate_cause_of_incident",
    "explosion_bomb_form.tested_by",
    "explosion_bomb_form.state_name",
    "explosion_bomb_form.alcohol_substance_test_results",
    "explosion_bomb_form.method_of_testing",
    "explosion_bomb_form.license_no_training_certificate_no",
    "explosion_bomb_form.year_issued",
    "explosion_bomb_form.issued_by",
    "explosion_bomb_form.incident_level",
    "explosion_bomb_form.reportable_cases_classification",
    "explosion_bomb_form.comments",
    "explosion_bomb_form.form_completed_by",
    "explosion_bomb_form.designation",
  ];
  const searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = explosion_bomb_form.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = explosion_bomb_form.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = explosion_bomb_form.department",
    },
    {
      type: "left",
      targetTable: "category_type",
      onCondition: "category_type.id = explosion_bomb_form.category_id",
    },
  ];
  const joinCondition = await makeJoins(joins);
  const explosionBombFormQuery = `SELECT explosion_bomb_form.* , organization.name as organization_name ,department.name as department_name , users.name as created_by_name , users.surname as created_by_surname  , users.profile as created_by_profile , category_type.name as category_name FROM explosion_bomb_form ${joinCondition} WHERE explosion_bomb_form.deleted = 0 ${condition} ${searchCondition}`;
  const totalRecord = await countQueryCondition(explosionBombFormQuery);

  const [explosionBombForm] = await db.query(explosionBombFormQuery);
  for (const data of explosionBombForm) {
    if (data.tested_by == "Internal") {
      if (data.tested_by_employee) {
        const [fetchUser] = await db.query(
          `SELECT CONCAT(name ,  ' ' , surname) AS name , profile FROM users WHERE id = ${Number(
            data.tested_by_employee
          )}`
        );
        data.tested_by_employee_name = fetchUser[0].name;
        data.tested_by_employee_profile = fetchUser[0].profile;
      }
    }
    data.comments = await decodeSingle_statement(data.comments);
  }
  return sendResponse(res, 200, explosionBombForm, totalRecord);
};

export const deleteExplosionBombForm = async (req, res) => {
  const { id } = req.params;
  const deleteForm = await deleteRecord("explosion_bomb_form", id);
  if (deleteForm) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Explosion Bomb Form",
      `This user deleted a new Explosion Bomb Form Record for organization ${id}`
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
  return sendResponse(res, 404, "Cannot delete record");
};
