import asyncHandler from "express-async-handler";
import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  whereCondition,
  settingsUpdater,
  createQueryBuilder,
  searchConditionRecord,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import FocusArea from "../sequelize/FocusAreaSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create and update Focus Area  */
export const createUpdatedFocusArea = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "FocusArea",
      "focus_area",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(FocusArea, req.body) : createQueryBuilder(FocusArea, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "FocusArea", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdatedFocusArea = async (req, res) => {
//   const { id, name, description, organization } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);
//   req.body.description = encodedDescription;

//   /**If id comes in body then it will update the query */
//   if (id) {
//     if (organization?.length === 0) {
//       return sendResponse(
//         res,
//         400,
//         "Please Select at least one business Structure"
//       );
//     }
//     const result = await settingsUpdater(
//       FocusArea,
//       organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }

//     /**Insert record for activity log */
//     insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Focus Area",
//       `This user Update Focus Area which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = organization.map(async (element) => {
//       /** Check if this organization already has the particular name */
//       const [checkNameWithOrganization] = await db.query(
//         `SELECT name FROM focus_area WHERE name = ? AND deleted = '0' AND organization = ?`,
//         [name, element]
//       );

//       /** If record not found for that name with particular organization, insert the record */
//       if (checkNameWithOrganization.length === 0) {
//         req.body.created_by = req.user.sessionid;
//         req.body.organization = element;
//         /** Insert Focus Area details */
//         const unique_id = await uniqueIdGenerator(
//           element,
//           req?.body?.department,
//           "FocusArea",
//           "focus_area",
//           "unique_id",
//           "unique_id"
//         );
//         req.body.unique_id = unique_id;

//         const { query, values } = createQueryBuilder(FocusArea, {
//           ...req.body,
//           organization: element,
//         });
//         await db.query(query, values);

//         /** Insert record for activity log */
//         insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Focus Area",
//           `This user created a new Focus Area named ${name} for organization ${element}`
//         );
//       }
//     });

//     await Promise.all(insertPromises);

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all Focus Area */
export const viewAllFocusArea = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "focus_area");

  // const condition = await whereCondition({
  //   table: "focus_area",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id: req.params.id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  /** If value come with any search condition then search that word */
  const searchTableName = ["focus_area.name", "focus_area.description", "createdUser.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = focus_area.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = focus_area.organization",
    // },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all focus areas */
  const focusAreaDataFetchQuery = `SELECT focus_area.unique_id,focus_area.id,focus_area.created_by as created_by_id,focus_area.name,focus_area.description,createdUser.name as created_by ,createdUser.surname as created_by_surname ,createdUser.profile as created_by_profile ,focus_area.organization, focus_area.organization as organizations
  FROM focus_area  
  ${joinsRecord} 
  where focus_area.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  let [focusAreaDataFetch] = await db.query(focusAreaDataFetchQuery);

  focusAreaDataFetch = await getListingData(focusAreaDataFetch);

  // for (const item of focusAreaDataFetch) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(`SELECT organization FROM focus_area WHERE deleted = 0 AND name = ?`, [
  //       item.name,
  //     ]);
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  /**Count all Focus Areas */
  const totalRecord = await countQueryCondition(focusAreaDataFetchQuery);

  return sendResponse(res, 200, focusAreaDataFetch, totalRecord);
};

/**Function to delete a specific Focus Area */
export const deleteFocusArea = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("focus_area", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "Focus Area", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
