import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import NameOfStandard from "../sequelize/NameOfStandardSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/**Function to create new Insurance Policy Impact for employee  */
export const createUpdateNameOfStandard = async (req, res) => {
  const { id, name, description, organization, department } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "NameOfStandard",
      "name_of_standard",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "name_of_standard",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "NameOfStandard name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "NameOfStandard name name  already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(NameOfStandard, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "NameOfStandard", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(NameOfStandard, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "NameOfStandard",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       200,
  //       "Please select at least one business structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     NameOfStandard,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Name of Standard",
  //     `This user Updated the Name of Standard which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const unique_id = await uniqueIdGenerator(
  //     organization,
  //     department,
  //     "NOS",
  //     "name_of_standard",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   /** Insert new record */
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM name_of_standard WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     // If record not found for that name with particular organization, insert the record
  //     if (checkNameWithOrganization.length === 0) {
  //       // Insert insurance Policy Impact details
  //       const insertNameOfStandardQuery = `INSERT INTO name_of_standard(name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`;
  //       await db.query(insertNameOfStandardQuery, [
  //         name,
  //         encodedDescription,
  //         req.user.sessionid,
  //         element,
  //         unique_id,
  //       ]);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Name Of Standard",
  //         `This user created a new category '${name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all and single Insurance Policy Impact */
export const viewNameOfStandard = async (req, res) => {


  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "name_of_standard"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "name_of_standard.name",
    "name_of_standard.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = name_of_standard.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let nameOfStandardQuery = `SELECT 
  name_of_standard.*, 
  name_of_standard.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM name_of_standard
${joinsRecord} 
WHERE name_of_standard.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [nameOfStandard] = await db.query(nameOfStandardQuery);
  nameOfStandard = await getListingData(nameOfStandard);
  /**Count all organization */
  const totalRecord = await countQueryCondition(nameOfStandardQuery);
  return sendResponse(res, 200, nameOfStandard, totalRecord);










  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "name_of_standard",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchTableName = [
  //   "name_of_standard.name",
  //   "name_of_standard.description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = name_of_standard.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = name_of_standard.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "department",
  //     onCondition: "department.id = name_of_standard.department",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const nameOfStandardQuery = `SELECT name_of_standard.*,users.id AS created_by_id, users.name AS created_by, organization.name AS organization_name , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM name_of_standard ${joinsRecord} where name_of_standard.deleted = 0 ${searchCondition} ${condition}`;

  // const [nameOfStandardRecord] = await db.query(nameOfStandardQuery);

  // for (const item of nameOfStandardRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM name_of_standard WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  // /**Count all organization */
  // const totalRecord = await countQueryCondition(nameOfStandardQuery);

  // return sendResponse(res, 200, nameOfStandardRecord, totalRecord);
};

/**Function to delete a specific Insurance Policy Impact */
export const deleteNameOfStandard = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("name_of_standard", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Name of standard",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
