import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement ,
  } from "../helper/general.js";
  import OccupationalDiseaseType from "../sequelize/OccupationalDiseaseTypeSchema.js";

  /** Function to create or update OccupationalDiseaseType */
  export const createUpdateOccupationalDiseaseType = async (req, res) => {
    const { id, name, description } = req.body;
    const encodedDescription = await encodeSingle_statement(description);

    if (id) {
      const result = await settingsUpdater(
        OccupationalDiseaseType,
        req.body.organization,
        req.body,
        req.user
      );
      if (!result) {
        return sendResponse(res, 404, "No data found");
      }
      await insertActivityLog(req.user.sessionid, "update", "OccupationalDiseaseType", `This user updated OccupationalDiseaseType with id: ${id}`);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
      const insertPromises = req.body.organization.map(async (org) => {
        const [checkName] = await db.query(`SELECT name FROM occupational_disease_type WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
        if (checkName.length === 0) {
          await db.query(`INSERT INTO occupational_disease_type (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
          await insertActivityLog(req.user.sessionid, "create", "OccupationalDiseaseType", `This user created a new OccupationalDiseaseType '${name}' for organization ${org}`);
        }
      });
      await Promise.all(insertPromises);
      return sendResponse(res, 200, "Record created successfully");
    }
  };

  /** Function to view all or single OccupationalDiseaseType */
  export const viewOccupationalDiseaseType = async (req, res) => {
    const { id } = req.params;
    const condition = await whereCondition({
      table: "occupational_disease_type",
      page: req.query.page,
      all: req.query.all,
      pageSize: req.query.pageSize,
      filter: req.query.filter,
      id,
      user: req.user,
      grouped: req.query.grouped,
    });

    const searchFields = [
      "occupational_disease_type.name",
      "occupational_disease_type.description",
      "users.name",
      "organization.name"
    ];
    let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    const joins = [
      { type: "left", targetTable: "users", onCondition: "users.id = occupational_disease_type.created_by" },
      { type: "left", targetTable: "organization", onCondition: "organization.id = occupational_disease_type.organization" }
    ];
    const joinsRecord = await makeJoins(joins);

    const fetchQuery = `SELECT occupational_disease_type.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM occupational_disease_type ${joinsRecord} WHERE occupational_disease_type.deleted = 0 ${searchCondition} ${condition}`;
    let [records] = await db.query(fetchQuery);

    for (const record of records) {
      record.description = await decodeSingle_statement(record.description);
       if (req.query.grouped == "true") {
        const [organizations] = await db.query(
          `SELECT organization FROM occupational_disease_type WHERE deleted = 0 AND name = ?`,
          [record.name]
        );
        const arr = organizations.map((item) => item.organization);
        record.organizations = arr;
      }
    }

    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete OccupationalDiseaseType */
  export const deleteOccupationalDiseaseType = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("occupational_disease_type", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "OccupationalDiseaseType", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };